/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.logging.jdk;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JPPFLogFormatter
extends Formatter {
    private final SimpleDateFormat sdf = new SimpleDateFormat("[yyyy/MM/dd hh:mm:ss.SSS]");

    @Override
    public String format(LogRecord record) {
        Object[] params;
        StringBuilder sb = new StringBuilder();
        sb.append(this.sdf.format(new Date(record.getMillis())));
        sb.append('[');
        String name = record.getLevel().getName();
        sb.append(name);
        for (int i = 0; i < 7 - name.length(); ++i) {
            sb.append(' ');
        }
        sb.append(']');
        sb.append('[');
        String s = record.getSourceClassName();
        String shortName = JPPFLogFormatter.getShortName(s);
        StackTraceElement[] elts = new Throwable().getStackTrace();
        StackTraceElement elt = null;
        for (StackTraceElement elt1 : elts) {
            if (!JPPFLogFormatter.getShortName(elt1.getClassName()).equals(shortName)) continue;
            elt = elt1;
            break;
        }
        if (elt != null) {
            sb.append(elt.getClassName());
            if (elt.getMethodName() != null) {
                sb.append('.').append(elt.getMethodName());
            }
            sb.append('(');
            if (elt.getLineNumber() >= 0) {
                sb.append(elt.getLineNumber());
            }
            sb.append(')');
        } else {
            if (s != null) {
                sb.append(s);
            }
            if ((s = record.getSourceMethodName()) != null) {
                sb.append('.').append(s).append("()");
            }
        }
        sb.append(']');
        sb.append(": ");
        s = record.getMessage();
        if (s != null) {
            sb.append(s);
        }
        if ((params = record.getParameters()) != null) {
            for (Object o : params) {
                sb.append('|').append(o);
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private static String getShortName(String fqn) {
        if (fqn == null) {
            return "";
        }
        int idx = fqn.lastIndexOf(46);
        return idx >= 0 ? fqn.substring(idx + 1) : fqn;
    }
}

