/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jppf.io.OutputDestination;
import org.jppf.utils.SerializationUtils;

public class StreamOutputDestination
implements OutputDestination {
    private OutputStream os = null;

    public StreamOutputDestination(OutputStream os) {
        this.os = os;
    }

    @Override
    public int write(byte[] buffer, int offset, int len) throws Exception {
        this.os.write(buffer, offset, len);
        return len;
    }

    @Override
    public int write(ByteBuffer buffer) throws Exception {
        int pos = buffer.position();
        ByteBuffer tmp = ByteBuffer.wrap(new byte[4096]);
        byte[] bytes = tmp.array();
        while (buffer.remaining() > 0) {
            int n = buffer.position();
            buffer.get(bytes, 0, Math.min(buffer.remaining(), bytes.length));
            n = buffer.position() - n;
            if (n <= 0) break;
            this.os.write(bytes, 0, n);
        }
        return buffer.position() - pos;
    }

    @Override
    public void writeInt(int value) throws Exception {
        byte[] bytes = SerializationUtils.writeInt(value);
        this.os.write(bytes);
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

