/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jppf.io.InputSource;
import org.jppf.utils.SerializationUtils;

public class StreamInputSource
implements InputSource {
    private InputStream is = null;

    public StreamInputSource(InputStream is) {
        this.is = is;
    }

    @Override
    public int read(byte[] data, int offset, int len) throws Exception {
        int n = this.is.read(data, offset, len);
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public int read(ByteBuffer buffer) throws Exception {
        int n;
        int pos = buffer.position();
        ByteBuffer tmp = ByteBuffer.wrap(new byte[4096]);
        byte[] bytes = tmp.array();
        while (buffer.remaining() > 0 && (n = this.read(bytes, 0, Math.min(buffer.remaining(), bytes.length))) > 0) {
            buffer.put(bytes, 0, n);
        }
        return buffer.position() - pos;
    }

    @Override
    public int readInt() throws Exception {
        byte[] value = new byte[4];
        this.read(value, 0, 4);
        return SerializationUtils.readInt(value, 0);
    }

    @Override
    public int skip(int n) throws Exception {
        return (int)this.is.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

