/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.jppf.io.OutputDestination;
import org.jppf.utils.SerializationUtils;
import org.jppf.utils.pooling.DirectBufferPool;

public class ChannelOutputDestination
implements OutputDestination {
    protected WritableByteChannel channel = null;

    public ChannelOutputDestination(WritableByteChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] data, int offset, int len) throws Exception {
        ByteBuffer tmpBuffer = null;
        try {
            int count;
            int n;
            tmpBuffer = DirectBufferPool.provideBuffer();
            int cap = tmpBuffer.capacity();
            boolean end = false;
            for (count = 0; count < len; count += n) {
                tmpBuffer.clear();
                int size = Math.min(cap, len - count);
                tmpBuffer.put(data, offset + count, size);
                tmpBuffer.flip();
                n = this.channel.write(tmpBuffer);
                if (n <= 0) break;
                if (n >= size) continue;
                break;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (tmpBuffer != null) {
                DirectBufferPool.releaseBuffer(tmpBuffer);
                tmpBuffer = null;
            }
        }
    }

    @Override
    public int write(ByteBuffer data) throws Exception {
        return this.channel.write(data);
    }

    @Override
    public void writeInt(int value) throws Exception {
        SerializationUtils.writeInt(this.channel, value);
    }

    @Override
    public void close() throws IOException {
    }
}

