/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jppf.io.InputSource;
import org.jppf.utils.SerializationUtils;
import org.jppf.utils.pooling.DirectBufferPool;

public class ChannelInputSource
implements InputSource {
    protected ReadableByteChannel channel = null;

    public ChannelInputSource(ReadableByteChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read(byte[] data, int offset, int len) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, len);
        return this.read(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer data) throws Exception {
        ByteBuffer tmpBuffer = null;
        try {
            int count;
            int n;
            tmpBuffer = DirectBufferPool.provideBuffer();
            int remaining = data.remaining();
            for (count = 0; count < remaining; count += n) {
                if (data.remaining() < tmpBuffer.remaining()) {
                    tmpBuffer.limit(data.remaining());
                }
                if ((n = this.channel.read(tmpBuffer)) < 0) {
                    throw new EOFException();
                }
                if (n == 0) break;
                tmpBuffer.flip();
                data.put(tmpBuffer);
                tmpBuffer.clear();
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (tmpBuffer != null) {
                DirectBufferPool.releaseBuffer(tmpBuffer);
                tmpBuffer = null;
            }
        }
    }

    @Override
    public int readInt() throws Exception {
        return SerializationUtils.readInt(this.channel);
    }

    @Override
    public int skip(int n) throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(n);
        this.read(buf);
        return buf.position();
    }

    @Override
    public void close() throws IOException {
    }
}

