/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buffer = null;

    public ByteBufferOutputStream(int capacity) {
        this.buffer = ByteBuffer.allocate(capacity);
    }

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.buffer = null;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buffer.put(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.put((byte)b);
    }

    public ByteBuffer toByteBuffer() {
        return this.buffer;
    }
}

