/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.socket;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.comm.socket.AbstractSocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketInitializerImpl
extends AbstractSocketInitializer {
    private static Logger log = LoggerFactory.getLogger(SocketInitializerImpl.class);
    private boolean debugEnabled = log.isDebugEnabled();
    private boolean traceEnabled = log.isTraceEnabled();
    private Date latestAttemptDate = null;
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private Timer timer = null;
    private SocketInitializationTask task = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSocket(SocketWrapper socketWrapper) {
        String errMsg = "SocketInitializer.initializeSocket(): Could not reconnect to the remote server";
        String fatalErrMsg = "FATAL: could not initialize the Socket Wrapper!";
        this.socketWrapper = socketWrapper;
        this.lock.lock();
        try {
            block11: {
                long maxTime;
                try {
                    if (this.debugEnabled) {
                        log.debug(this.name + "about to close socket wrapper " + socketWrapper);
                    }
                    socketWrapper.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                TypedProperties props = JPPFConfiguration.getProperties();
                long delay = 1000L * props.getLong("reconnect.initial.delay", 0L);
                if (delay == 0L) {
                    delay = this.rand.nextInt(10);
                }
                long maxDuration = (maxTime = props.getLong("reconnect.max.time", 60L)) <= 0L ? -1L : 1000L * maxTime;
                long period = 1000L * props.getLong("reconnect.interval", 1L);
                this.latestAttemptDate = maxDuration > 0L ? new Date(System.currentTimeMillis() + maxDuration) : null;
                this.task = new SocketInitializationTask();
                this.timer = new Timer("Socket initializer (" + this.instanceNumber + ") timer for " + socketWrapper, true);
                this.timer.schedule((TimerTask)this.task, delay, period);
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    if (!this.debugEnabled) break block11;
                    log.debug(this.name + e.getMessage(), (Throwable)e);
                }
            }
            this.timer.cancel();
            this.timer.purge();
            if (!this.isSuccessful() && !this.closed) {
                if (this.debugEnabled) {
                    log.debug(this.name + errMsg);
                }
                System.err.println(this.name + errMsg);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.debugEnabled) {
                log.debug(this.name + "closing socket initializer");
            }
            this.closed = true;
            if (this.task != null) {
                this.task.cancel();
            }
            if (this.timer != null) {
                if (this.debugEnabled) {
                    log.debug(this.name + " timer not null");
                }
                this.timer.cancel();
                this.timer.purge();
                this.timer = null;
            }
            this.signalAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalAll() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    class SocketInitializationTask
    extends TimerTask {
        SocketInitializationTask() {
        }

        @Override
        public void run() {
            block8: {
                ++SocketInitializerImpl.this.attemptCount;
                try {
                    if (SocketInitializerImpl.this.traceEnabled) {
                        log.trace(SocketInitializerImpl.this.name + " opening the socket connection");
                    }
                    SocketInitializerImpl.this.socketWrapper.open();
                    SocketInitializerImpl.this.successfull = true;
                    if (SocketInitializerImpl.this.traceEnabled) {
                        log.trace(SocketInitializerImpl.this.name + " socket connection successfully opened");
                    }
                    this.reset();
                }
                catch (Exception e) {
                    Date now;
                    if (SocketInitializerImpl.this.traceEnabled) {
                        if (SocketInitializerImpl.this.attemptCount > 1) {
                            log.trace("socket connection open failed for " + SocketInitializerImpl.this.socketWrapper + " : " + ExceptionUtils.getMessage(e));
                        } else {
                            log.trace("socket connection open failed for " + SocketInitializerImpl.this.socketWrapper, (Throwable)e);
                        }
                    }
                    if (SocketInitializerImpl.this.latestAttemptDate == null || !(now = new Date()).after(SocketInitializerImpl.this.latestAttemptDate)) break block8;
                    SocketInitializerImpl.this.successfull = false;
                    if (SocketInitializerImpl.this.traceEnabled) {
                        log.trace(SocketInitializerImpl.this.name + " socket initialization unsuccessful");
                    }
                    this.reset();
                }
            }
        }

        private void reset() {
            this.cancel();
            SocketInitializerImpl.this.signalAll();
        }
    }
}

