/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.socket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import org.jppf.JPPFException;
import org.jppf.comm.socket.AbstractSocketWrapper;
import org.jppf.comm.socket.BootstrapObjectSerializer;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.ObjectSerializer;

public class BootstrapSocketClient
extends AbstractSocketWrapper {
    public BootstrapSocketClient() {
    }

    public BootstrapSocketClient(String host, int port) throws ConnectException, IOException {
        super(host, port, null);
    }

    public BootstrapSocketClient(Socket socket) throws JPPFException {
        super(socket);
    }

    @Override
    public void send(Object o) throws Exception {
        JPPFBuffer buffer = this.getSerializer().serialize(o);
        this.sendBytes(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object receive(int timeout) throws Exception {
        this.checkOpened();
        Object o = null;
        try {
            if (timeout > 0) {
                this.socket.setSoTimeout(timeout);
            }
            JPPFBuffer buf = this.receiveBytes(timeout);
            o = this.getSerializer().deserialize(buf);
        }
        finally {
            if (timeout > 0) {
                this.socket.setSoTimeout(0);
            }
        }
        return o;
    }

    @Override
    public ObjectSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new BootstrapObjectSerializer();
        }
        return this.serializer;
    }
}

