/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.socket;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jppf.serialization.JPPFObjectStreamFactory;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.streams.JPPFByteArrayOutputStream;

public class BootstrapObjectSerializer
implements ObjectSerializer {
    @Override
    public JPPFBuffer serialize(Object o) throws Exception {
        return this.serialize(o, false);
    }

    @Override
    public JPPFBuffer serialize(Object o, boolean noCopy) throws Exception {
        JPPFByteArrayOutputStream baos = new JPPFByteArrayOutputStream();
        this.serialize(o, baos);
        byte[] data = noCopy ? baos.getBuf() : baos.toByteArray();
        return new JPPFBuffer(data, baos.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Object o, OutputStream os) throws Exception {
        ObjectOutputStream oos = JPPFObjectStreamFactory.newObjectOutputStream(os);
        try {
            oos.writeObject(o);
            oos.flush();
        }
        finally {
            oos.close();
        }
    }

    @Override
    public Object deserialize(JPPFBuffer buf) throws Exception {
        return this.deserialize(new ByteArrayInputStream(buf.getBuffer()));
    }

    @Override
    public Object deserialize(byte[] bytes) throws Exception {
        return this.deserialize(new ByteArrayInputStream(bytes));
    }

    @Override
    public Object deserialize(byte[] bytes, int offset, int length) throws Exception {
        return this.deserialize(new ByteArrayInputStream(bytes, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserialize(InputStream is) throws Exception {
        Object o = null;
        ObjectInputStream ois = JPPFObjectStreamFactory.newObjectInputStream(is);
        try {
            o = ois.readObject();
        }
        finally {
            ois.close();
        }
        return o;
    }
}

