/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.recovery;

import java.util.ArrayList;
import java.util.List;
import org.jppf.comm.recovery.AbstractRecoveryConnection;
import org.jppf.comm.recovery.ClientConnectionEvent;
import org.jppf.comm.recovery.ClientConnectionListener;
import org.jppf.comm.socket.BootstrapSocketClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnection
extends AbstractRecoveryConnection {
    private static Logger log = LoggerFactory.getLogger(ClientConnection.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final ClientConnectionListener[] ZERO_CONNECTION_LISTENER = new ClientConnectionListener[0];
    private SocketInitializer socketInitializer;
    private final List<ClientConnectionListener> listeners = new ArrayList<ClientConnectionListener>();

    public ClientConnection(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public void run() {
        try {
            this.configure();
            if (debugEnabled) {
                log.debug("initializing recovery client connection " + this.socketWrapper);
            }
            this.socketInitializer = new SocketInitializerImpl();
            this.socketInitializer.initializeSocket(this.socketWrapper);
            if (!this.socketInitializer.isSuccessful()) {
                log.error("Could not initialize recovery client connection " + this.socketWrapper);
                this.close();
                return;
            }
            while (!this.isStopped()) {
                String message = this.receiveMessage(this.maxRetries, this.socketReadTimeout);
                if (message != null && message.startsWith("handshake")) {
                    this.setInitialized(true);
                }
                String response = "checked;" + this.uuid;
                this.sendMessage(response);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.fireClientConnectionEvent();
            this.close();
        }
        if (debugEnabled) {
            log.debug(Thread.currentThread().getName() + " stopping");
        }
    }

    private void configure() {
        if (debugEnabled) {
            log.debug("configuring connection");
        }
        TypedProperties config = JPPFConfiguration.getProperties();
        String host = config.getString("jppf.server.host", "localhost");
        int port = config.getInt("jppf.recovery.server.port", 22222);
        this.maxRetries = config.getInt("jppf.recovery.max.retries", 2);
        this.socketReadTimeout = config.getInt("jppf.recovery.read.timeout", 60000);
        this.socketWrapper = new BootstrapSocketClient();
        this.socketWrapper.setHost(host);
        this.socketWrapper.setPort(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.setStopped(true);
        try {
            if (debugEnabled) {
                log.debug("closing connection");
            }
            SocketWrapper tmp = this.socketWrapper;
            this.socketWrapper = null;
            if (tmp != null) {
                tmp.close();
            }
            if (this.socketInitializer != null) {
                this.socketInitializer.close();
            }
            this.socketInitializer = null;
            List<ClientConnectionListener> list = this.listeners;
            synchronized (list) {
                this.listeners.clear();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientConnectionListener(ClientConnectionListener listener) {
        if (listener == null) {
            return;
        }
        List<ClientConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientConnectionListener(ClientConnectionListener listener) {
        if (listener == null) {
            return;
        }
        List<ClientConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireClientConnectionEvent() {
        ClientConnectionListener[] tmp;
        ClientConnectionEvent event = new ClientConnectionEvent(this);
        List<ClientConnectionListener> list = this.listeners;
        synchronized (list) {
            tmp = this.listeners.toArray(new ClientConnectionListener[this.listeners.size()]);
        }
        for (ClientConnectionListener listener : tmp) {
            listener.clientConnectionFailed(event);
        }
    }
}

