/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.recovery;

import java.net.SocketTimeoutException;
import org.jppf.JPPFException;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecoveryConnection
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(AbstractRecoveryConnection.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    protected SocketWrapper socketWrapper = null;
    protected int maxRetries;
    protected int socketReadTimeout;
    protected String uuid = null;
    protected boolean ok;
    protected boolean initialized;

    protected String receiveMessage() throws Exception {
        return this.receiveMessage(this.maxRetries, this.socketReadTimeout);
    }

    protected String receiveMessage(int maxRetries, int socketReadTimeout) throws Exception {
        String message = null;
        JPPFBuffer buffer = null;
        int retries = 0;
        boolean success = false;
        while (retries < maxRetries && !success) {
            try {
                buffer = this.socketWrapper.receiveBytes(socketReadTimeout);
                success = true;
                message = buffer.asString();
                if (!traceEnabled) continue;
                log.trace(this + " received '" + message + '\'');
            }
            catch (SocketTimeoutException e) {
                ++retries;
                if (!debugEnabled) continue;
                log.debug(this + " retry #" + retries + " failed!");
            }
        }
        if (!success) {
            throw new JPPFException("could not get a message from the remote peer");
        }
        return message;
    }

    public void sendMessage(String message) throws Exception {
        JPPFBuffer buffer = new JPPFBuffer(message);
        this.socketWrapper.sendBytes(buffer);
        if (traceEnabled) {
            log.trace(this + " sent '" + message + '\'');
        }
    }

    public abstract void close();

    public String getUuid() {
        return this.uuid;
    }

    public synchronized boolean isOk() {
        return this.ok;
    }

    public synchronized void setOk(boolean ok) {
        this.ok = ok;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

