/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.discovery;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.ThreadSynchronization;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFMulticastReceiver
extends ThreadSynchronization {
    private static Logger log = LoggerFactory.getLogger(JPPFMulticastReceiver.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private static TypedProperties config = JPPFConfiguration.getProperties();
    private String group = "230.0.0.1";
    private int port = 11111;
    private int timeout = 5000;
    private InetAddress groupInetAddress = null;
    private LinkedList<JPPFConnectionInformation> infoList = new LinkedList();
    private AtomicLong count = new AtomicLong(0L);
    private IPFilter ipFilter = null;

    public JPPFMulticastReceiver() {
        this(null);
    }

    public JPPFMulticastReceiver(IPFilter ipFilter) {
        this.group = config.getString("jppf.discovery.group", "230.0.0.1");
        this.port = config.getInt("jppf.discovery.port", 11111);
        this.timeout = config.getInt("jppf.discovery.timeout", 5000);
        this.ipFilter = ipFilter;
    }

    public JPPFMulticastReceiver(String group, int port, int timeout) {
        this.group = group;
        this.port = port;
        this.timeout = timeout;
    }

    public synchronized JPPFConnectionInformation receive() {
        JPPFConnectionInformation info;
        block12: {
            info = null;
            try {
                if (this.groupInetAddress == null) {
                    this.groupInetAddress = InetAddress.getByName(this.group);
                    List<InetAddress> addresses = NetworkUtils.getNonLocalIPAddresses();
                    if (addresses.isEmpty()) {
                        addresses.add(InetAddress.getByName("127.0.0.1"));
                    }
                    int len = addresses.size();
                    if (debugEnabled) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Found ").append(len).append(" address");
                        if (len > 1) {
                            sb.append("es");
                        }
                        sb.append(':');
                        for (InetAddress addr : addresses) {
                            sb.append(' ').append(addr.getHostAddress());
                        }
                        log.debug(sb.toString());
                    }
                    Receiver[] receivers = new Receiver[len];
                    for (int i = 0; i < len; ++i) {
                        receivers[i] = new Receiver(addresses.get(i), this.port);
                    }
                    for (Receiver r : receivers) {
                        r.start();
                    }
                }
                if (!this.hasConnectionInfo()) {
                    this.wait(this.timeout);
                } else {
                    this.wait(50L);
                }
                info = this.getMostRecent();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) break block12;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (traceEnabled) {
            log.trace("Auto-discovery of the driver connection information: " + info);
        }
        return info;
    }

    private synchronized void addConnectionInfo(JPPFConnectionInformation info) {
        try {
            if (this.ipFilter != null && !this.ipFilter.isAddressAccepted(InetAddress.getByName(info.host))) {
                return;
            }
        }
        catch (UnknownHostException e) {
            return;
        }
        this.infoList.remove(info);
        this.infoList.addFirst(info);
        if (debugEnabled) {
            log.debug("nb connections: " + this.infoList.size());
        }
        this.notifyAll();
    }

    private synchronized JPPFConnectionInformation getMostRecent() {
        if (this.infoList.isEmpty()) {
            return null;
        }
        return this.infoList.getFirst();
    }

    private synchronized boolean hasConnectionInfo() {
        return !this.infoList.isEmpty();
    }

    private synchronized InetAddress getGroupInetAddress() {
        return this.groupInetAddress;
    }

    private synchronized void setGroupInetAddress(InetAddress groupInetAddress) {
        this.groupInetAddress = groupInetAddress;
    }

    public class Receiver
    extends Thread {
        private InetAddress addr;
        private int port;
        private JPPFConnectionInformation info;

        public Receiver(InetAddress addr, int port) {
            super("Receiver@" + addr.getHostAddress() + ':' + port);
            this.addr = null;
            this.port = 0;
            this.info = null;
            this.addr = addr;
            this.port = port;
        }

        @Override
        public void run() {
            MulticastSocket socket = null;
            try {
                int t = 1000;
                socket = new MulticastSocket(this.port);
                socket.setInterface(this.addr);
                socket.joinGroup(JPPFMulticastReceiver.this.getGroupInetAddress());
                socket.setSoTimeout(JPPFMulticastReceiver.this.timeout);
                byte[] buf = new byte[512];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                while (!JPPFMulticastReceiver.this.isStopped()) {
                    long start = System.currentTimeMillis();
                    while (System.currentTimeMillis() - start < (long)t) {
                        block8: {
                            try {
                                socket.receive(packet);
                                ByteBuffer buffer = ByteBuffer.wrap(buf);
                                int len = buffer.getInt();
                                byte[] bytes = new byte[len];
                                buffer.get(bytes);
                                this.info = JPPFConnectionInformation.fromBytes(bytes);
                                String host = config.getString("jppf.management.host", null);
                                if (host == null) {
                                    host = this.addr.getHostAddress();
                                }
                                this.info.managementHost = host;
                                JPPFMulticastReceiver.this.addConnectionInfo(this.info);
                            }
                            catch (SocketTimeoutException e) {
                                if (!debugEnabled) break block8;
                                log.debug(e.getMessage(), (Throwable)e);
                            }
                        }
                        if (System.currentTimeMillis() - start >= (long)t) continue;
                        Thread.sleep(50L);
                    }
                }
                socket.leaveGroup(JPPFMulticastReceiver.this.getGroupInetAddress());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (socket != null) {
                socket.close();
            }
        }

        public JPPFConnectionInformation getInfo() {
            return this.info;
        }
    }
}

