/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.discovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFConnectionInformation
implements Serializable,
Comparable<JPPFConnectionInformation>,
Cloneable {
    private static Logger log = LoggerFactory.getLogger(JPPFConnectionInformation.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private static final long serialVersionUID = 1L;
    public String host = null;
    public int[] serverPorts = null;
    public int[] sslServerPorts = null;
    public int managementPort = -1;
    public int sslManagementPort = -1;
    public int recoveryPort = -1;
    public transient String managementHost = null;
    public String uuid = null;
    public int subnetMaskLength = 0;

    @Override
    public int compareTo(JPPFConnectionInformation ci) {
        if (ci == null || ci.uuid == null) {
            return 1;
        }
        if (this.uuid == null) {
            return -1;
        }
        return this.uuid.compareTo(ci.uuid);
    }

    public int hashCode() {
        return 31 + (this.uuid == null ? 0 : this.uuid.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JPPFConnectionInformation other = (JPPFConnectionInformation)obj;
        if (this.uuid == null) {
            return other.uuid == null;
        }
        return this.uuid.equals(other.uuid);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("uuid=").append(this.uuid);
        sb.append(", host=").append(this.host);
        sb.append(", managementPort=").append(this.managementPort);
        sb.append(", recoveryPort=").append(this.recoveryPort);
        sb.append(", serverPorts=").append(StringUtils.buildString(this.serverPorts));
        sb.append(", sslServerPorts=").append(StringUtils.buildString(this.sslServerPorts));
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JPPFConnectionInformation fromBytes(byte[] bytes) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        JPPFConnectionInformation info = null;
        try {
            info = (JPPFConnectionInformation)ois.readObject();
        }
        finally {
            ois.close();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(JPPFConnectionInformation info) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(info);
            oos.close();
        }
        finally {
            oos.close();
        }
        return baos.toByteArray();
    }
}

