/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.discovery;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.Pair;
import org.jppf.utils.ThreadSynchronization;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFBroadcaster
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(JPPFBroadcaster.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private List<Pair<MulticastSocket, DatagramPacket>> socketsInfo;
    private long broadcastInterval = 1000L;
    private JPPFConnectionInformation info = null;
    private Set<Pair<MulticastSocket, DatagramPacket>> socketsInError = new HashSet<Pair<MulticastSocket, DatagramPacket>>();

    public JPPFBroadcaster(JPPFConnectionInformation info) {
        this.info = info;
    }

    private void init() throws Exception {
        TypedProperties props = JPPFConfiguration.getProperties();
        this.broadcastInterval = props.getLong("jppf.discovery.broadcast.interval", 1000L);
        String group = props.getString("jppf.discovery.group", "230.0.0.1");
        int port = props.getInt("jppf.discovery.port", 11111);
        List<InetAddress> addresses = NetworkUtils.getNonLocalIPV4Addresses();
        addresses.addAll(NetworkUtils.getNonLocalIPV6Addresses());
        if (addresses.isEmpty()) {
            addresses.add(InetAddress.getByName("127.0.0.1"));
        }
        IPFilter filter = new IPFilter(props, true);
        LinkedList<InetAddress> filteredAddresses = new LinkedList<InetAddress>();
        for (InetAddress addr : addresses) {
            if (!filter.isAddressAccepted(addr)) continue;
            filteredAddresses.add(addr);
        }
        if (debugEnabled) {
            StringBuilder sb = new StringBuilder();
            sb.append("Found ").append(filteredAddresses.size()).append(" address");
            if (filteredAddresses.size() > 1) {
                sb.append("es");
            }
            sb.append(':');
            for (InetAddress addr : filteredAddresses) {
                sb.append(' ').append(addr.getHostAddress());
            }
            log.debug(sb.toString());
        }
        this.socketsInfo = new ArrayList<Pair<MulticastSocket, DatagramPacket>>(filteredAddresses.size());
        for (InetAddress addr : addresses) {
            try {
                JPPFConnectionInformation ci = (JPPFConnectionInformation)this.info.clone();
                ci.host = addr.getHostAddress();
                ci.subnetMaskLength = NetworkUtils.getSubnetMaskLength(addr);
                byte[] infoBytes = JPPFConnectionInformation.toBytes(ci);
                ByteBuffer buffer = ByteBuffer.wrap(new byte[512]);
                buffer.putInt(infoBytes.length);
                buffer.put(infoBytes);
                DatagramPacket packet = new DatagramPacket(buffer.array(), 512, InetAddress.getByName(group), port);
                MulticastSocket socket = new MulticastSocket(port);
                socket.setInterface(addr);
                this.socketsInfo.add(new Pair<MulticastSocket, DatagramPacket>(socket, packet));
            }
            catch (Exception e) {
                log.error("Unable to bind to interface " + addr.getHostAddress() + " on port " + port, (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.setStopped(true);
        }
        while (!this.isStopped()) {
            for (Pair<MulticastSocket, DatagramPacket> si : this.socketsInfo) {
                try {
                    si.first().send(si.second());
                    if (!this.socketsInError.contains(si)) continue;
                    this.socketsInError.remove(si);
                }
                catch (Exception e) {
                    if (this.socketsInError.contains(si)) continue;
                    this.socketsInError.add(si);
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.socketsInfo.isEmpty()) {
                this.setStopped(true);
            }
            if (this.isStopped()) continue;
            this.goToSleep(this.broadcastInterval);
        }
        for (Pair<MulticastSocket, DatagramPacket> socketInfo : this.socketsInfo) {
            socketInfo.first().close();
        }
        this.socketsInfo.clear();
    }
}

