/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.discovery;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.jppf.net.AbstractIPAddressPattern;
import org.jppf.net.IPv4AddressPattern;
import org.jppf.net.IPv6AddressPattern;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFilter {
    private static Logger log = LoggerFactory.getLogger(IPFilter.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private List<AbstractIPAddressPattern> includePatterns = new ArrayList<AbstractIPAddressPattern>();
    private List<AbstractIPAddressPattern> excludePatterns = new ArrayList<AbstractIPAddressPattern>();
    private TypedProperties config = null;
    private final boolean broadcaster;

    public IPFilter(TypedProperties config) {
        this(config, false);
    }

    public IPFilter(TypedProperties config, boolean broadcaster) {
        this.config = config == null ? new TypedProperties() : config;
        this.broadcaster = broadcaster;
        this.configure();
    }

    public void configure() {
        String prefix = "jppf.discovery." + (this.broadcaster ? "broadcast." : "");
        this.configureIPAddressPatterns(this.config.getString(prefix + "include.ipv4"), this.includePatterns, true);
        this.configureIPAddressPatterns(this.config.getString(prefix + "include.ipv6"), this.includePatterns, false);
        this.configureIPAddressPatterns(this.config.getString(prefix + "exclude.ipv4"), this.excludePatterns, true);
        this.configureIPAddressPatterns(this.config.getString(prefix + "exclude.ipv6"), this.excludePatterns, false);
    }

    private void configureIPAddressPatterns(String source, List<AbstractIPAddressPattern> addToList, boolean ipv4) {
        if (source == null) {
            return;
        }
        String src = source.trim();
        if ("".equals(src)) {
            return;
        }
        String[] p = src.split(",|;");
        if (p == null || p.length == 0) {
            return;
        }
        for (String s : p) {
            try {
                addToList.add(ipv4 ? new IPv4AddressPattern(s) : new IPv6AddressPattern(s));
            }
            catch (Exception e) {
                log.warn(ExceptionUtils.getMessage(e));
            }
        }
    }

    public boolean isAddressAccepted(InetAddress ip) {
        int[] ipComps = NetworkUtils.toIntArray(ip);
        boolean included = this.matches(ipComps, this.includePatterns, true);
        boolean excluded = this.matches(ipComps, this.excludePatterns, false);
        return included && !excluded;
    }

    private boolean matches(int[] ipComps, List<AbstractIPAddressPattern> patterns, boolean defIfEmpty) {
        if (patterns == null || patterns.isEmpty()) {
            return defIfEmpty;
        }
        for (AbstractIPAddressPattern p : patterns) {
            if (!p.matches(ipComps)) continue;
            return true;
        }
        return false;
    }
}

