/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader.resource;

import java.io.File;
import java.security.PrivilegedAction;
import java.util.List;
import org.jppf.classloader.resource.FileResource;
import org.jppf.classloader.resource.MemoryResource;
import org.jppf.classloader.resource.Resource;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFConfiguration;

public class SaveResourceAction
implements PrivilegedAction<Resource> {
    private static final String FILE_STORAGE = "file";
    private static final String MEMORY_STORAGE = "memory";
    private static final boolean IS_MEMORY_STORAGE = SaveResourceAction.isMemoryStorageType();
    private List<String> tmpDirs = null;
    private String name = null;
    private final byte[] definition;
    private Exception exception = null;

    public SaveResourceAction(List<String> tmpDirs, String name, byte[] definition) {
        this.tmpDirs = tmpDirs;
        this.name = name;
        this.definition = definition;
    }

    @Override
    public Resource run() {
        Resource resource = null;
        if (!IS_MEMORY_STORAGE) {
            resource = this.saveToFileResource();
        }
        if (resource == null) {
            resource = this.saveToMemoryResource();
        }
        return resource;
    }

    private Resource saveToFileResource() {
        FileResource resource;
        block4: {
            resource = null;
            File tmp = null;
            try {
                for (String s : this.tmpDirs) {
                    File f = new File(s, this.name);
                    if (f.exists()) continue;
                    tmp = f;
                    break;
                }
                if (tmp == null) {
                    String dir = this.tmpDirs.get(0) + '_' + this.tmpDirs.size();
                    File f = new File(dir + File.separator);
                    FileUtils.mkdirs(f);
                    f.deleteOnExit();
                    tmp = new File(f, this.name);
                    this.tmpDirs.add(dir);
                }
                FileUtils.mkdirs(tmp);
                tmp.deleteOnExit();
                FileUtils.writeBytesToFile(this.definition, tmp);
                resource = new FileResource(tmp);
                this.exception = null;
            }
            catch (Exception e) {
                this.exception = e;
                if (tmp == null || !tmp.exists()) break block4;
                tmp.delete();
                tmp = null;
            }
        }
        return resource;
    }

    private Resource saveToMemoryResource() {
        MemoryResource resource = null;
        try {
            resource = new MemoryResource(this.definition);
            this.exception = null;
        }
        catch (Exception e) {
            this.exception = e;
        }
        return resource;
    }

    public Exception getException() {
        return this.exception;
    }

    private static boolean isMemoryStorageType() {
        String s = JPPFConfiguration.getProperties().getString("jppf.resource.cache.storage", FILE_STORAGE);
        return MEMORY_STORAGE.equalsIgnoreCase(s);
    }
}

