/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader.resource;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jppf.classloader.resource.FileResource;
import org.jppf.classloader.resource.MemoryResource;
import org.jppf.classloader.resource.Resource;
import org.jppf.classloader.resource.SaveResourceAction;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFUuid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCache {
    private static Logger log = LoggerFactory.getLogger(ResourceCache.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private static final Map<String, ResourceCache> cacheMap = new Hashtable<String, ResourceCache>();
    private static String ROOT_NAME = ".jppf";
    private Map<String, List<Resource>> cache = new Hashtable<String, List<Resource>>();
    private List<String> tempFolders = new LinkedList<String>();
    private final String uuid = new JPPFUuid(JPPFUuid.HEXADECIMAL_CHAR, 32).toString();
    private final Thread shutdownHook = new Thread(new ShutdownHook(this.tempFolders, this.uuid));

    public ResourceCache() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        cacheMap.put(this.uuid, this);
        this.initTempFolders();
    }

    public synchronized List<Resource> getResourcesLocations(String name) {
        return this.cache.get(name);
    }

    public synchronized List<URL> getResourcesURLs(String name) {
        List<Resource> resources = this.getResourcesLocations(name);
        if (resources == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>(resources.size());
        int count = 0;
        for (Resource res : resources) {
            URL url = this.getResourceURL(name, res, count++);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    private synchronized Resource getResourceLocation(String name) {
        List<Resource> locations = this.cache.get(name);
        if (locations == null || locations.isEmpty()) {
            return null;
        }
        return locations.get(0);
    }

    private synchronized void setResourcesLocations(String name, List<Resource> locations) {
        this.cache.put(name, locations);
    }

    public synchronized void registerResources(String name, List<byte[]> definitions) {
        if (this.isAbsolutePath(name)) {
            return;
        }
        LinkedList<Resource> locations = new LinkedList<Resource>();
        for (byte[] def : definitions) {
            try {
                locations.add(this.saveToTempFile(name, def));
            }
            catch (Exception e) {
                String s = "Exception caught while saving resource named '" + name + "' : ";
                if (debugEnabled) {
                    log.debug(s, (Throwable)e);
                    continue;
                }
                log.warn(s + ExceptionUtils.getMessage(e));
            }
        }
        if (!locations.isEmpty()) {
            this.setResourcesLocations(name, locations);
        }
    }

    private Resource saveToTempFile(String name, byte[] definition) throws Exception {
        SaveResourceAction action = new SaveResourceAction(this.tempFolders, name, definition);
        Resource file = AccessController.doPrivileged(action);
        if (action.getException() != null) {
            throw action.getException();
        }
        if (traceEnabled) {
            log.trace("saved resource [" + name + "] to file " + file);
        }
        return file;
    }

    public URL getResourceURL(String name) {
        return this.getResourceURL(name, this.getResourceLocation(name), 0);
    }

    private URL getResourceURL(String name, Resource res, int id) {
        if (res instanceof FileResource) {
            File path = (File)((FileResource)res).getPath();
            if (path == null) {
                return null;
            }
            return FileUtils.getURLFromFilePath(path);
        }
        if (res instanceof MemoryResource) {
            String s = "jppfres://" + this.uuid + '/' + name + "?id=" + id;
            try {
                return new URL(s);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private void initTempFolders() {
        try {
            String base = JPPFConfiguration.getProperties().getString("jppf.resource.cache.dir", null);
            if (base == null) {
                base = System.getProperty("java.io.tmpdir");
                if (base == null) {
                    base = System.getProperty("user.home");
                }
                if (base == null) {
                    base = System.getProperty("user.dir");
                }
                if (base != null) {
                    if (!base.endsWith(File.separator)) {
                        base = base + File.separator;
                    }
                    base = base + ROOT_NAME;
                }
            }
            if (base == null) {
                base = "." + File.separator + ROOT_NAME;
            }
            if (traceEnabled) {
                log.trace("base = " + base);
            }
            String s = base + File.separator + this.uuid;
            File baseDir = new File(s + File.separator);
            FileUtils.mkdirs(baseDir);
            this.tempFolders.add(s);
            if (traceEnabled) {
                log.trace("added temp folder " + s);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isAbsolutePath(String path) {
        if (path.startsWith("/") || path.startsWith("\\")) {
            return true;
        }
        if (path.length() < 3) {
            return false;
        }
        char c = path.charAt(0);
        return (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && path.charAt(1) == ':';
    }

    public synchronized void close() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new ShutdownHook(this.tempFolders, this.uuid).run();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String getUuid() {
        return this.uuid;
    }

    public static ResourceCache getCacheInstance(String uuid) {
        return cacheMap.get(uuid);
    }

    private static final class ShutdownHook
    extends Thread {
        private final List<String> tempFolders;
        private final String uuid;

        private ShutdownHook(List<String> tempFolders, String uuid) {
            this.tempFolders = tempFolders;
            this.uuid = uuid;
        }

        @Override
        public void run() {
            cacheMap.remove(this.uuid);
            while (!this.tempFolders.isEmpty()) {
                FileUtils.deletePath(new File(this.tempFolders.remove(0)));
            }
        }
    }
}

