/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jppf.classloader.resource.AbstractResource;
import org.jppf.classloader.resource.BoundedByteArrayOutputStream;

public class MemoryResource
extends AbstractResource<byte[]> {
    private static final long serialVersionUID = 1L;
    private int offset = 0;
    private int len = -1;

    public MemoryResource(int size) {
        this(new byte[size], 0, size);
    }

    public MemoryResource(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public MemoryResource(byte[] buffer, int offset, int len) {
        super(buffer);
        this.offset = offset;
        this.len = len;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        return new ByteArrayInputStream((byte[])this.path, this.offset, this.len);
    }

    @Override
    public OutputStream getOutputStream() throws Exception {
        return new BoundedByteArrayOutputStream((byte[])this.path, this.offset, this.len);
    }

    @Override
    public long size() {
        return this.len;
    }

    @Override
    public byte[] toByteArray() throws Exception {
        return (byte[])this.path;
    }
}

