/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader.resource;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;

public class BoundedByteArrayOutputStream
extends OutputStream {
    private final byte[] buf;
    private final int length;
    private final int offset;
    private int pos = 0;
    private boolean eof = false;

    public BoundedByteArrayOutputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.eof) {
            throw new EOFException("buffer overflow");
        }
        this.buf[this.offset + this.pos++] = (byte)b;
        this.eof = this.pos >= this.length - 1;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            throw new EOFException("buffer overflow");
        }
        int min = Math.min(len, this.length - this.pos);
        System.arraycopy(b, off, this.buf, this.offset + this.pos, min);
        this.pos += min;
        boolean bl = this.eof = this.pos >= this.length - 1;
        if (this.eof && len > min) {
            throw new EOFException("buffer overflow, could only write " + min + " bytes out of " + len);
        }
    }
}

