/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.jppf.classloader.resource.Resource;
import org.jppf.utils.streams.JPPFByteArrayOutputStream;

public abstract class AbstractResource<T>
implements Serializable,
Resource<T> {
    protected T path = null;

    public AbstractResource(T path) {
        this.path = path;
    }

    @Override
    public T getPath() {
        return this.path;
    }

    @Override
    public void copyTo(Resource location) throws Exception {
        InputStream is = this.getInputStream();
        OutputStream os = location.getOutputStream();
        this.copyStream(is, os);
        is.close();
        os.flush();
        os.close();
    }

    @Override
    public byte[] toByteArray() throws Exception {
        InputStream is = this.getInputStream();
        JPPFByteArrayOutputStream os = new JPPFByteArrayOutputStream();
        this.copyStream(is, os);
        is.close();
        os.flush();
        os.close();
        return os.toByteArray();
    }

    public String toString() {
        return String.valueOf(this.getPath());
    }

    private void copyStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] bytes = new byte[4096];
        while ((n = is.read(bytes)) > 0) {
            os.write(bytes, 0, n);
        }
    }
}

