/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Map;
import org.jppf.utils.StringUtils;
import org.jppf.utils.streams.StreamConstants;
import org.jppf.utils.streams.StreamUtils;

public class NonDelegatingClassLoader
extends URLClassLoader {
    private static Map<String, byte[]> resourceMap = new Hashtable<String, byte[]>();

    public NonDelegatingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls == null ? StringUtils.ZERO_URL : urls, parent);
    }

    public Class<?> loadClassDirect(String name) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            byte[] classBytes = this.getResourceBytes(name);
            if (classBytes != null) {
                c = this.defineClass(name, classBytes, 0, classBytes.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            c = super.loadClass(name);
        }
        return c;
    }

    private byte[] getResourceBytes(String name) {
        byte[] b;
        block7: {
            b = resourceMap.get(name);
            if (b == null) {
                String resName = name.replace('.', '/') + ".class";
                InputStream is = this.getResourceAsStream(resName);
                if (is != null) {
                    try {
                        b = StreamUtils.getInputStreamAsByte(is);
                        if (b != null) {
                            resourceMap.put(name, b);
                            break block7;
                        }
                        resourceMap.put(name, StreamConstants.EMPTY_BYTES);
                    }
                    catch (Exception e) {}
                }
            } else if (b.length == 0) {
                b = null;
            }
        }
        return b;
    }
}

