/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.utils.TraversalList;

public class JPPFResourceWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong CALLABLE_ID = new AtomicLong(0L);
    private static final long NO_CALLABLE_ID = -1L;
    public static final JPPFResourceWrapper[] EMPTY_RESOURCE_WRAPPER_ARRAY = new JPPFResourceWrapper[0];
    private TraversalList<String> uuidPath = new TraversalList();
    private boolean dynamic = false;
    private State state = null;
    private String providerUuid = null;
    private boolean asResource = false;
    private String requestUuid = null;
    private final Map<String, Object> dataMap = new HashMap<String, Object>();
    private transient JPPFResourceWrapper[] resources = null;

    public void addUuid(String uuid) {
        this.uuidPath.add(uuid);
    }

    public String getName() {
        return (String)this.getData("name");
    }

    public void setName(String name) {
        this.setData("name", name);
    }

    public byte[] getDefinition() {
        return (byte[])this.getData("definition");
    }

    public void setDefinition(byte[] definition) {
        this.setData("definition", definition);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Map<String, Object> map = this.dataMap;
        synchronized (map) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(State state) {
        Map<String, Object> map = this.dataMap;
        synchronized (map) {
            this.state = state;
        }
    }

    public TraversalList<String> getUuidPath() {
        return this.uuidPath;
    }

    public void setUuidPath(TraversalList<String> uuidPath) {
        this.uuidPath = uuidPath;
    }

    public String getProviderUuid() {
        return this.providerUuid;
    }

    public void setProviderUuid(String providerUuid) {
        this.providerUuid = providerUuid;
    }

    public boolean isAsResource() {
        return this.asResource;
    }

    public void setAsResource(boolean asResource) {
        this.asResource = asResource;
    }

    public String getRequestUuid() {
        return this.requestUuid;
    }

    public void setRequestUuid(String requestUuid) {
        this.requestUuid = requestUuid;
    }

    public byte[] getCallable() {
        return (byte[])this.getData("callable");
    }

    public void setCallable(byte[] callable) {
        this.setData("callable", callable);
    }

    protected long getCallableID() {
        Long id = (Long)this.getData("callable.id");
        return id == null ? -1L : id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(String key) {
        Map<String, Object> map = this.dataMap;
        synchronized (map) {
            return this.dataMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(String key, Object def) {
        Map<String, Object> map = this.dataMap;
        synchronized (map) {
            Object o = this.dataMap.get(key);
            return o == null ? def : o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object value) {
        Map<String, Object> map = this.dataMap;
        synchronized (map) {
            this.dataMap.put(key, value);
        }
    }

    public JPPFResourceWrapper[] getResources() {
        if (this.resources == null) {
            this.resources = new JPPFResourceWrapper[]{this};
        }
        return this.resources;
    }

    protected Object getMonitor() {
        return this.dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("dynamic=").append(this.dynamic);
        sb.append(", asResource=").append(this.asResource);
        sb.append(", state=").append((Object)this.state);
        byte[] callable = this.getCallable();
        Map<String, Object> map = this.dataMap;
        synchronized (map) {
            if (callable == null) {
                sb.append(", data=").append(this.dataMap);
            } else {
                sb.append(", callable=").append(callable.toString()).append(", callableID=").append(this.getCallableID());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    void preProcess() {
        if (this.getCallable() != null && this.getCallableID() == -1L) {
            this.setData("callable.id", CALLABLE_ID.incrementAndGet());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JPPFResourceWrapper other = (JPPFResourceWrapper)obj;
        return this.dynamic == other.dynamic && this.uuidPath.equals(other.uuidPath) && this.getCallableID() == other.getCallableID() && this.getName().equals(other.getName());
    }

    public int hashCode() {
        Long id = this.getCallableID();
        return 31 + (this.dynamic ? 1 : 0) + this.uuidPath.hashCode() + (id != null ? id.intValue() : 0) + this.getName().hashCode();
    }

    public static enum State {
        NODE_INITIATION,
        NODE_REQUEST,
        NODE_RESPONSE,
        NODE_RESPONSE_ERROR,
        PROVIDER_INITIATION,
        PROVIDER_REQUEST,
        PROVIDER_RESPONSE;

    }
}

