/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.ClassLoaderRequestHandler;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.LocalClassLoaderChannel;
import org.jppf.classloader.LocalResourceRequest;
import org.jppf.node.NodeRunner;
import org.jppf.utils.StringUtils;
import org.jppf.utils.TraversalList;
import org.jppf.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFLocalClassLoader
extends AbstractJPPFClassLoader {
    private static Logger log = LoggerFactory.getLogger(JPPFLocalClassLoader.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final LocalClassLoaderChannel channel;

    public JPPFLocalClassLoader(LocalClassLoaderChannel ioHandler, ClassLoader parent) {
        super(parent);
        this.channel = ioHandler;
        this.init();
    }

    public JPPFLocalClassLoader(ClassLoader parent, List<String> uuidPath) {
        super(parent, uuidPath);
        this.channel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        block11: {
            LOCK.lock();
            try {
                if (!INITIALIZING.compareAndSet(false, true)) break block11;
                try {
                    if (debugEnabled) {
                        log.debug("sending node initiation message");
                    }
                    LocalResourceRequest rr = new LocalResourceRequest(this.channel);
                    JPPFResourceWrapper resource = new JPPFResourceWrapper();
                    resource.setState(JPPFResourceWrapper.State.NODE_INITIATION);
                    resource.setData("node.uuid", NodeRunner.getUuid());
                    rr.setRequest(resource);
                    rr.run();
                    rr.reset();
                    Throwable t = rr.getThrowable();
                    if (t != null) {
                        throw new RuntimeException(t);
                    }
                    requestHandler = new ClassLoaderRequestHandler(rr);
                    if (debugEnabled) {
                        log.debug("received node initiation response");
                    }
                    System.out.println(StringUtils.build(this.getClass().getSimpleName(), ": Reconnected to the class server"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    INITIALIZING.set(false);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    @Override
    public void reset() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOCK.lock();
        try {
            if (requestHandler != null) {
                requestHandler.close();
                requestHandler = null;
            }
            super.close();
        }
        finally {
            LOCK.unlock();
        }
    }

    @Override
    public synchronized Class<?> loadJPPFClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (debugEnabled) {
            log.debug(StringUtils.build("looking up resource [", name, "]"));
        }
        if ((c = this.findLoadedClass(name)) == null) {
            if (debugEnabled) {
                log.debug(StringUtils.build("resource [", name, "] not already loaded"));
            }
            ClassLoader cl = this;
            while (cl instanceof AbstractJPPFClassLoader) {
                cl = cl.getParent();
            }
            if (cl != null) {
                String pkgName;
                Package pkg;
                int i = name.lastIndexOf(46);
                if (i >= 0 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
                String resName = name.replace(".", "/") + ".class";
                InputStream is = cl.getResourceAsStream(resName);
                try {
                    byte[] definition = StreamUtils.getInputStreamAsByte(is);
                    c = this.defineClass(name, definition, 0, definition.length);
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (c == null) {
            c = this.findClass(name);
        }
        if (debugEnabled) {
            log.debug(StringUtils.build("definition for resource [", name, "] : ", c));
        }
        return c;
    }

    @Override
    protected JPPFResourceWrapper loadRemoteData(Map<String, Object> map, boolean asResource) throws Exception {
        JPPFResourceWrapper resource = new JPPFResourceWrapper();
        resource.setState(JPPFResourceWrapper.State.NODE_REQUEST);
        resource.setDynamic(this.dynamic);
        TraversalList<String> list = new TraversalList<String>(this.uuidPath);
        resource.setUuidPath(list);
        if (list.size() > 0) {
            list.setPosition(this.uuidPath.size() - 1);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            resource.setData(entry.getKey(), entry.getValue());
        }
        resource.setAsResource(asResource);
        resource.setRequestUuid(this.requestUuid);
        Future<JPPFResourceWrapper> f = requestHandler.addRequest(resource);
        return f.get();
    }
}

