/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jppf.JPPFException;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.AbstractJPPFClassLoaderLifeCycle;
import org.jppf.classloader.ClassLoaderRequestHandler;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.RemoteResourceRequest;
import org.jppf.classloader.ResourceFuture;
import org.jppf.comm.socket.BootstrapSocketClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.node.NodeRunner;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TraversalList;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFClassLoader
extends AbstractJPPFClassLoader {
    private static Logger log = LoggerFactory.getLogger(JPPFClassLoader.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private SocketWrapper socketClient = null;
    private static SocketInitializer socketInitializer = new SocketInitializerImpl();
    private static boolean sslEnabled = false;

    public JPPFClassLoader(ClassLoader parent) {
        super(parent);
        this.init();
    }

    public JPPFClassLoader(ClassLoader parent, List<String> uuidPath) {
        super(parent, uuidPath);
    }

    private void initSocketClient() {
        if (debugEnabled) {
            log.debug("initializing socket connection");
        }
        TypedProperties props = JPPFConfiguration.getProperties();
        sslEnabled = props.getBoolean("jppf.ssl.enabled", false);
        String host = props.getString("jppf.server.host", "localhost");
        int port = props.getAndReplaceInt("jppf.server.port", "class.server.port", sslEnabled ? 11443 : 11111, false);
        if (debugEnabled) {
            log.debug("host=" + host + ", port=" + port + ", ssl=" + sslEnabled);
        }
        this.socketClient = new BootstrapSocketClient();
        this.socketClient.setHost(host);
        this.socketClient.setPort(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        block10: {
            LOCK.lock();
            try {
                if (!INITIALIZING.compareAndSet(false, true)) break block10;
                try {
                    if (debugEnabled) {
                        log.debug("initializing connection");
                    }
                    if (this.socketClient == null) {
                        this.initSocketClient();
                    }
                    System.out.println("Attempting connection to the class server at " + this.socketClient.getHost() + ':' + this.socketClient.getPort());
                    socketInitializer.initializeSocket(this.socketClient);
                    if (!socketInitializer.isSuccessful()) {
                        this.socketClient = null;
                        throw new JPPFNodeReconnectionNotification("Could not reconnect to the server");
                    }
                    if (sslEnabled) {
                        this.createSSLConnection();
                    }
                    this.performHandshake();
                    System.out.println("Reconnected to the class server");
                }
                finally {
                    INITIALIZING.set(false);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    private void createSSLConnection() {
        try {
            this.socketClient = SSLHelper.createSSLClientConnection(this.socketClient);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void performHandshake() {
        try {
            if (debugEnabled) {
                log.debug("sending channel identifier");
            }
            this.socketClient.writeInt(65533);
            this.socketClient.flush();
            if (debugEnabled) {
                log.debug("sending node initiation message");
            }
            JPPFResourceWrapper request = new JPPFResourceWrapper();
            request.setState(JPPFResourceWrapper.State.NODE_INITIATION);
            request.setData("node.uuid", NodeRunner.getUuid());
            RemoteResourceRequest rr = new RemoteResourceRequest(this.getSerializer(), this.socketClient);
            rr.setRequest(request);
            rr.run();
            Throwable t = rr.getThrowable();
            if (t != null) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
            if (debugEnabled) {
                log.debug("received node initiation response");
            }
            rr.reset();
            requestHandler = new ClassLoaderRequestHandler(rr);
        }
        catch (IOException e) {
            throw new JPPFNodeReconnectionNotification("Could not reconnect to the driver", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        LOCK.lock();
        try {
            Class<JPPFClassLoader> clazz = JPPFClassLoader.class;
            synchronized (JPPFClassLoader.class) {
                this.socketClient = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.init();
            }
        }
        finally {
            LOCK.unlock();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        LOCK.lock();
        try {
            Class<AbstractJPPFClassLoaderLifeCycle> clazz = AbstractJPPFClassLoaderLifeCycle.class;
            synchronized (AbstractJPPFClassLoaderLifeCycle.class) {
                if (requestHandler != null) {
                    requestHandler.close();
                    requestHandler = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                clazz = JPPFClassLoader.class;
                synchronized (JPPFClassLoader.class) {
                    if (socketInitializer != null) {
                        socketInitializer.close();
                    }
                    if (this.socketClient != null) {
                        block14: {
                            try {
                                this.socketClient.close();
                            }
                            catch (Exception e) {
                                if (!debugEnabled) break block14;
                                log.debug(e.getMessage(), (Throwable)e);
                            }
                        }
                        this.socketClient = null;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    super.close();
                    return;
                }
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    @Override
    protected JPPFResourceWrapper loadRemoteData(Map<String, Object> map, boolean asResource) throws Exception {
        JPPFResourceWrapper resource = new JPPFResourceWrapper();
        resource.setState(JPPFResourceWrapper.State.NODE_REQUEST);
        resource.setDynamic(this.dynamic);
        TraversalList<String> list = new TraversalList<String>(this.uuidPath);
        resource.setUuidPath(list);
        if (list.size() > 0) {
            list.setPosition(this.uuidPath.size() - 1);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            resource.setData(entry.getKey(), entry.getValue());
        }
        resource.setAsResource(asResource);
        resource.setRequestUuid(this.requestUuid);
        Future<JPPFResourceWrapper> f = requestHandler.addRequest(resource);
        resource = f.get();
        Throwable t = ((ResourceFuture)f).getThrowable();
        if (t != null) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new JPPFException(t);
        }
        return resource;
    }
}

