/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceFuture;

public class CompositeResourceWrapper
extends JPPFResourceWrapper {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCES_KEY = "resources";
    private final transient Map<JPPFResourceWrapper, Future<JPPFResourceWrapper>> futureMap = new HashMap<JPPFResourceWrapper, Future<JPPFResourceWrapper>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JPPFResourceWrapper[] getResources() {
        Object object = this.getMonitor();
        synchronized (object) {
            Set resources = (Set)this.getData(RESOURCES_KEY);
            if (resources == null || resources.isEmpty()) {
                return EMPTY_RESOURCE_WRAPPER_ARRAY;
            }
            return resources.toArray(new JPPFResourceWrapper[resources.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrReplaceResource(JPPFResourceWrapper resource) {
        Object object = this.getMonitor();
        synchronized (object) {
            HashSet<JPPFResourceWrapper> resources = (HashSet<JPPFResourceWrapper>)this.getData(RESOURCES_KEY);
            if (resources == null) {
                resources = new HashSet<JPPFResourceWrapper>();
                this.setData(RESOURCES_KEY, resources);
            } else {
                resources.remove(resource);
            }
            resources.add(resource);
        }
    }

    public Future<JPPFResourceWrapper> addResource(JPPFResourceWrapper resource) {
        Future<JPPFResourceWrapper> f = this.futureMap.get(resource);
        if (f == null) {
            this.addOrReplaceResource(resource);
            f = new ResourceFuture<JPPFResourceWrapper>();
            this.futureMap.put(resource, f);
        }
        return f;
    }

    public Map<JPPFResourceWrapper, Future<JPPFResourceWrapper>> getFutureMap() {
        return this.futureMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        Object object = this.getMonitor();
        synchronized (object) {
            sb.append("resources=").append(this.getData(RESOURCES_KEY));
        }
        sb.append(']');
        return sb.toString();
    }
}

