/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.util.Map;
import java.util.concurrent.Future;
import org.jppf.classloader.CompositeResourceWrapper;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceFuture;
import org.jppf.classloader.ResourceRequest;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.StringUtils;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderRequestHandler {
    private static Logger log = LoggerFactory.getLogger(ClassLoaderRequestHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final long MAX_WAIT = 100L;
    private static final int NANO_RANGE = 1000000;
    private CompositeResourceWrapper nextRequest = null;
    private ResourceRequest requestRunner;
    private PeriodicTask periodicTask = new PeriodicTask();
    private int maxBatchSize = 0;

    public ClassLoaderRequestHandler(ResourceRequest requestRunner) {
        this.nextRequest = new CompositeResourceWrapper();
        this.requestRunner = requestRunner;
        new Thread((Runnable)this.periodicTask, "PeriodicTask").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<JPPFResourceWrapper> addRequest(JPPFResourceWrapper resource) {
        Future<JPPFResourceWrapper> f;
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        resource.preProcess();
        PeriodicTask periodicTask = this.periodicTask;
        synchronized (periodicTask) {
            f = this.nextRequest.addResource(resource);
        }
        this.periodicTask.wakeUp();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<JPPFResourceWrapper> addRequest(JPPFResourceWrapper resource, ClassLoader cl) {
        Future<JPPFResourceWrapper> f;
        resource.preProcess();
        PeriodicTask periodicTask = this.periodicTask;
        synchronized (periodicTask) {
            f = this.nextRequest.addResource(resource);
            ((ResourceFuture)f).setCl(cl);
        }
        this.periodicTask.wakeUp();
        return f;
    }

    public void close() {
        this.periodicTask.setStopped(true);
        this.requestRunner = null;
        this.nextRequest = null;
    }

    private class PeriodicTask
    extends ThreadSynchronization
    implements Runnable {
        private PeriodicTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long elapsed = 0L;
                while (!this.isStopped()) {
                    CompositeResourceWrapper request = null;
                    long start = System.nanoTime();
                    PeriodicTask periodicTask = this;
                    synchronized (periodicTask) {
                        while (ClassLoaderRequestHandler.this.nextRequest.getFutureMap().isEmpty()) {
                            this.goToSleep();
                        }
                        while ((elapsed = System.nanoTime() - start) < 100L) {
                            this.goToSleep((100L - elapsed) / 1000000L, (int)((100L - elapsed) % 1000000L));
                        }
                        if (this.isStopped()) {
                            return;
                        }
                        request = ClassLoaderRequestHandler.this.nextRequest;
                        ClassLoaderRequestHandler.this.nextRequest = new CompositeResourceWrapper();
                    }
                    Map<JPPFResourceWrapper, Future<JPPFResourceWrapper>> futureMap = request.getFutureMap();
                    int n = futureMap.size();
                    if (n > ClassLoaderRequestHandler.this.maxBatchSize) {
                        ClassLoaderRequestHandler.this.maxBatchSize = n;
                        log.info(StringUtils.build("maxBatchSize = ", ClassLoaderRequestHandler.this.maxBatchSize));
                    }
                    if (debugEnabled) {
                        log.debug(StringUtils.build("sending batch of ", futureMap.size(), " class loading requests: ", request));
                    }
                    if (this.isStopped()) {
                        return;
                    }
                    ClassLoaderRequestHandler.this.requestRunner.setRequest(request);
                    ClassLoaderRequestHandler.this.requestRunner.run();
                    Throwable t = ClassLoaderRequestHandler.this.requestRunner.getThrowable();
                    CompositeResourceWrapper response = (CompositeResourceWrapper)ClassLoaderRequestHandler.this.requestRunner.getResponse();
                    if (debugEnabled) {
                        log.debug(StringUtils.build("got response ", response));
                    }
                    if (response != null) {
                        for (JPPFResourceWrapper rw : response.getResources()) {
                            ResourceFuture f = (ResourceFuture)futureMap.remove(rw);
                            if (f == null) continue;
                            f.setDone(rw);
                        }
                    }
                    for (Map.Entry<JPPFResourceWrapper, Future<JPPFResourceWrapper>> entry : futureMap.entrySet()) {
                        ResourceFuture future = (ResourceFuture)entry.getValue();
                        if (t != null) {
                            future.setThrowable(t);
                            continue;
                        }
                        future.setDone(null);
                    }
                    futureMap.clear();
                    ClassLoaderRequestHandler.this.requestRunner.reset();
                    start = System.nanoTime();
                    elapsed = 0L;
                }
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                log.warn(ExceptionUtils.getMessage(e));
            }
        }
    }
}

