/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.caching.JPPFCollectionCache;
import org.jppf.caching.JPPFSimpleSetCache;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.ClassLoaderRequestHandler;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.resource.ResourceCache;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFClassLoaderLifeCycle
extends URLClassLoader {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClassLoaderLifeCycle.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected static final ReentrantLock LOCK = new ReentrantLock();
    protected static final AtomicBoolean INITIALIZING = new AtomicBoolean(false);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    protected static ClassLoaderRequestHandler requestHandler = null;
    protected boolean dynamic = false;
    protected List<String> uuidPath = new ArrayList<String>();
    protected String requestUuid = null;
    protected final ResourceCache cache = new ResourceCache();
    protected final JPPFCollectionCache<String> nfCache = new JPPFSimpleSetCache<String>();
    protected ObjectSerializer serializer = null;
    protected final int instanceNumber = INSTANCE_COUNT.incrementAndGet();

    protected AbstractJPPFClassLoaderLifeCycle(ClassLoader parent) {
        super(StringUtils.ZERO_URL, parent);
        if (parent instanceof AbstractJPPFClassLoaderLifeCycle) {
            this.dynamic = true;
        }
    }

    protected AbstractJPPFClassLoaderLifeCycle(ClassLoader parent, List<String> uuidPath) {
        this(parent);
        this.uuidPath = uuidPath;
    }

    protected abstract void init();

    public abstract void reset();

    protected JPPFResourceWrapper loadResourceData(Map<String, Object> map, boolean asResource) throws ClassNotFoundException {
        JPPFResourceWrapper resource;
        block6: {
            resource = null;
            try {
                if (debugEnabled) {
                    log.debug(StringUtils.build("loading remote definition for resource [", map.get("name"), "]"));
                }
                resource = this.loadResourceData0(map, asResource);
            }
            catch (IOException e) {
                if (debugEnabled) {
                    log.debug("connection with class server ended, re-initializing, exception is:", (Throwable)e);
                }
                throw new JPPFNodeReconnectionNotification("connection with class server ended, re-initializing, exception is:", e);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                if (!debugEnabled) break block6;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return resource;
    }

    protected JPPFResourceWrapper loadResourceData0(Map<String, Object> map, boolean asResource) throws Exception {
        if (debugEnabled) {
            log.debug(StringUtils.build("loading remote definition for resource [", map.get("name"), "], requestUuid = ", this.requestUuid));
        }
        JPPFResourceWrapper resource = this.loadRemoteData(map, false);
        if (debugEnabled) {
            log.debug(StringUtils.build("remote definition for resource [", map.get("name") + "] ", resource.getDefinition() == null ? "not " : "", "found"));
        }
        return resource;
    }

    protected abstract JPPFResourceWrapper loadRemoteData(Map<String, Object> var1, boolean var2) throws Exception;

    static boolean isInitializing() {
        return INITIALIZING.get();
    }

    static void setInitializing(boolean initFlag) {
        INITIALIZING.set(initFlag);
    }

    public void setRequestUuid(String requestUuid) {
        this.requestUuid = requestUuid;
    }

    @Override
    public abstract void close();

    protected ObjectSerializer getSerializer() throws Exception {
        if (this.serializer == null) {
            this.serializer = (ObjectSerializer)this.getParent().loadClass("org.jppf.comm.socket.BootstrapObjectSerializer").newInstance();
        }
        return this.serializer;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[id=").append(this.instanceNumber).append(", type=").append(this.dynamic ? "client" : "server");
        URL[] urls = this.getURLs();
        if (urls != null && urls.length > 0) {
            sb.append(", classpath=");
            for (int i = 0; i < urls.length; ++i) {
                if (i > 0) {
                    sb.append(';');
                }
                sb.append(urls[i]);
            }
        }
        sb.append(']');
        return sb.toString();
    }

    protected URL[] findMultipleResources(String ... names) {
        if (names == null || names.length <= 0) {
            return StringUtils.ZERO_URL;
        }
        URL[] results = new URL[names.length];
        boolean[] alreadyNotFound = new boolean[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = null;
            alreadyNotFound[i] = this.nfCache.has(names[i]);
        }
        try {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < names.length; ++i) {
                if (alreadyNotFound[i]) continue;
                String name = names[i];
                List<URL> locationsList = this.cache.getResourcesURLs(name);
                if (locationsList != null && !locationsList.isEmpty()) {
                    results[i] = locationsList.get(0);
                    if (!debugEnabled) continue;
                    log.debug(StringUtils.build("resource ", name, " found in local cache as ", results[i]));
                    continue;
                }
                URL url = super.findResource(names[i]);
                if (url != null) {
                    results[i] = url;
                    if (!debugEnabled) continue;
                    log.debug(StringUtils.build("resource ", name, " found in URL classpath as ", results[i]));
                    continue;
                }
                if (debugEnabled) {
                    log.debug(StringUtils.build("resource ", name, " not found locally"));
                }
                indices.add(i);
            }
            if (indices.isEmpty()) {
                if (debugEnabled) {
                    log.debug("all resources were found locally");
                }
                return results;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            String[] namesToLookup = new String[indices.size()];
            for (int i = 0; i < indices.size(); ++i) {
                namesToLookup[i] = names[(Integer)indices.get(i)];
            }
            map.put("name", StringUtils.arrayToString(", ", null, null, namesToLookup));
            map.put("multiple.resources.names", namesToLookup);
            JPPFResourceWrapper resource = this.loadResourceData(map, true);
            Map dataMap = (Map)resource.getData("resource_map");
            for (Integer index : indices) {
                boolean found;
                String name = names[index];
                List dataList = (List)dataMap.get(name);
                boolean bl = found = dataList != null && !dataList.isEmpty();
                if (debugEnabled && !found) {
                    log.debug(StringUtils.build("resource [", name, "] not found remotely"));
                }
                if (found) {
                    URL url;
                    this.cache.registerResources(name, dataList);
                    results[index.intValue()] = url = this.cache.getResourceURL(name);
                    if (!debugEnabled) continue;
                    log.debug(StringUtils.build("resource [", name, "] found remotely as ", url));
                    continue;
                }
                if (resource == null) continue;
                this.nfCache.add(name);
            }
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.warn(ExceptionUtils.getMessage(e));
        }
        return results;
    }

    public URL[] getMultipleResources(String ... names) {
        URL[] results;
        block15: {
            if (names == null || names.length <= 0) {
                return StringUtils.ZERO_URL;
            }
            int length = names.length;
            results = new URL[length];
            boolean[] alreadyNotFound = new boolean[length];
            for (int i = 0; i < length; ++i) {
                results[i] = null;
                alreadyNotFound[i] = this.nfCache.has(names[i]);
            }
            try {
                int i;
                ClassLoader parent = this.getParent();
                if (parent == null) {
                    for (i = 0; i < length; ++i) {
                        if (alreadyNotFound[i]) continue;
                        results[i] = AbstractJPPFClassLoaderLifeCycle.getSystemResource(names[i]);
                    }
                } else if (!(parent instanceof AbstractJPPFClassLoader)) {
                    for (i = 0; i < length; ++i) {
                        if (alreadyNotFound[i]) continue;
                        results[i] = parent.getResource(names[i]);
                    }
                } else {
                    results = ((AbstractJPPFClassLoader)parent).getMultipleResources(names);
                }
                for (i = 0; i < length; ++i) {
                    if (results[i] != null) continue;
                    results[i] = super.getResource(names[i]);
                }
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i2 = 0; i2 < length; ++i2) {
                    if (results[i2] != null) continue;
                    indices.add(i2);
                }
                if (!indices.isEmpty()) {
                    String[] namesToFind = new String[indices.size()];
                    for (int i3 = 0; i3 < namesToFind.length; ++i3) {
                        namesToFind[i3] = names[(Integer)indices.get(i3)];
                    }
                    URL[] foundURLs = this.findMultipleResources(namesToFind);
                    for (int i4 = 0; i4 < namesToFind.length; ++i4) {
                        results[((Integer)indices.get((int)i4)).intValue()] = foundURLs[i4];
                    }
                }
            }
            catch (Exception e) {
                if (!debugEnabled) break block15;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return results;
    }
}

