/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.jppf.classloader.AbstractJPPFClassLoaderLifeCycle;
import org.jppf.classloader.DelegationModel;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.IteratorEnumeration;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFClassLoader
extends AbstractJPPFClassLoaderLifeCycle {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClassLoader.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static DelegationModel delegationModel = AbstractJPPFClassLoader.initDelegationModel();
    private ClassLoader systemClassLoader = null;
    private boolean systemClassLoaderInitialized = false;

    public AbstractJPPFClassLoader(ClassLoader parent) {
        super(parent);
    }

    public AbstractJPPFClassLoader(ClassLoader parent, List<String> uuidPath) {
        super(parent, uuidPath);
    }

    public synchronized Class<?> loadJPPFClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (debugEnabled) {
            log.debug(StringUtils.build("looking up resource [", name, "]"));
        }
        if ((c = this.findLoadedClass(name)) != null && debugEnabled) {
            log.debug("classloader = " + c.getClassLoader());
        }
        if (c == null) {
            if (debugEnabled) {
                log.debug(StringUtils.build("resource [", name, "] not already loaded"));
            }
            c = this.findClass(name, true);
        }
        if (debugEnabled) {
            log.debug(StringUtils.build("definition for resource [", name, "] : ", c));
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Class<?> findClass(String name, boolean lookupClasspath) throws ClassNotFoundException {
        Class<?> c = null;
        if (this.nfCache.has(name)) {
            throw new ClassNotFoundException(StringUtils.build("Could not load class '", name, "'"));
        }
        c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (lookupClasspath) {
            c = this.findClassInURLClasspath(name, false);
        }
        if (c != null) {
            return c;
        }
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            String pkgName = name.substring(0, i);
            AbstractJPPFClassLoader abstractJPPFClassLoader = this;
            synchronized (abstractJPPFClassLoader) {
                Package pkg = this.getPackage(pkgName);
                if (pkg == null) {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
        }
        if (debugEnabled) {
            log.debug(StringUtils.build("looking up definition for resource [", name, "]"));
        }
        byte[] b = null;
        String resName = name.replace('.', '/') + ".class";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", resName);
        JPPFResourceWrapper resource = null;
        AbstractJPPFClassLoader abstractJPPFClassLoader = this;
        synchronized (abstractJPPFClassLoader) {
            resource = this.loadResourceData(map, false);
        }
        if (resource != null) {
            b = resource.getDefinition();
        }
        if (b == null || b.length == 0) {
            if (debugEnabled) {
                log.debug("definition for resource [" + name + "] not found");
            }
            if (resource != null) {
                this.nfCache.add(name);
            }
            throw new ClassNotFoundException(StringUtils.build("Could not load class '", name, "'"));
        }
        if (debugEnabled) {
            log.debug(StringUtils.build("found definition for resource [", name, ", definitionLength=", b.length, "]"));
        }
        abstractJPPFClassLoader = this;
        synchronized (abstractJPPFClassLoader) {
            c = this.findLoadedClass(name);
            return c == null ? this.defineClass(name, b, 0, b.length) : c;
        }
    }

    public byte[] computeRemoteData(byte[] callable) throws Exception {
        if (debugEnabled) {
            log.debug(StringUtils.build("requesting remote computation, requestUuid = ", this.requestUuid));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "callable");
        map.put("callable", callable);
        JPPFResourceWrapper resource = this.loadRemoteData(map, false);
        byte[] b = null;
        if (resource != null && resource.getState() == JPPFResourceWrapper.State.NODE_RESPONSE) {
            b = resource.getCallable();
        }
        if (debugEnabled) {
            log.debug(StringUtils.build("remote definition for callable resource ", b == null ? "not " : "", "found"));
        }
        return b;
    }

    @Override
    public URL findResource(String name) {
        URL url = null;
        if (this.nfCache.has(name)) {
            return null;
        }
        url = this.cache.getResourceURL(name);
        if (debugEnabled) {
            log.debug(StringUtils.build("resource [", name, "] ", url == null ? "not " : "", "found in local cache"));
        }
        if (url == null) {
            url = super.findResource(name);
            if (debugEnabled) {
                log.debug(StringUtils.build("resource [", name, "] ", url == null ? "not " : "", "found in URL classpath"));
            }
            if (url == null) {
                if (debugEnabled) {
                    log.debug(StringUtils.build("resource [", name, "] not found locally, attempting remote lookup"));
                }
                try {
                    List<URL> urlList = this.findRemoteResources(name);
                    if (urlList != null && !urlList.isEmpty()) {
                        url = urlList.get(0);
                    }
                }
                catch (Exception e) {
                    if (debugEnabled) {
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                    log.warn(ExceptionUtils.getMessage(e));
                }
                if (debugEnabled) {
                    log.debug(StringUtils.build("resource [", name, "] ", url == null ? "not " : "", "found remotely"));
                }
            }
        }
        if (url == null) {
            this.nfCache.add(name);
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        try {
            URL url = this.getResource(name);
            if (url != null) {
                is = url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return is;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        List<Object> urlList = new ArrayList();
        if (!this.nfCache.has(name)) {
            if (debugEnabled) {
                log.debug(StringUtils.build("resource [", name, "] not found locally, attempting remote lookup"));
            }
            try {
                Enumeration<URL> tempEnum;
                List<URL> tempList;
                urlList = this.cache.getResourcesURLs(name);
                if (urlList == null) {
                    urlList = new ArrayList();
                }
                if ((tempList = this.findRemoteResources(name)) != null) {
                    urlList.addAll(tempList);
                }
                if ((tempEnum = super.findResources(name)) != null) {
                    while (tempEnum.hasMoreElements()) {
                        urlList.add(tempEnum.nextElement());
                    }
                }
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                } else {
                    log.warn(ExceptionUtils.getMessage(e));
                }
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }
        if (urlList.isEmpty()) {
            this.nfCache.add(name);
        }
        return new IteratorEnumeration<URL>(urlList.iterator());
    }

    private List<URL> findRemoteResources(String name) throws Exception {
        List<URL> urlList = new ArrayList<URL>();
        JPPFResourceWrapper resource = null;
        if (!this.nfCache.has(name)) {
            boolean found;
            Object locationsList = null;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", name);
            map.put("multiple", "true");
            resource = this.loadResourceData(map, true);
            List dataList = null;
            if (resource != null) {
                dataList = (List)resource.getData("resource_list");
            }
            boolean bl = found = dataList != null && !dataList.isEmpty();
            if (debugEnabled) {
                log.debug(StringUtils.build("resource [", name, "] ", found ? "" : "not ", "found remotely"));
            }
            if (found) {
                this.cache.registerResources(name, dataList);
                urlList = this.cache.getResourcesURLs(name);
            }
        }
        if (urlList == null || urlList.isEmpty() && resource != null) {
            this.nfCache.add(name);
        }
        return urlList;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (AbstractJPPFClassLoader.getDelegationModel() == DelegationModel.URL_FIRST) {
            return this.loadClassLocalFirst(name, resolve);
        }
        return super.loadClass(name, resolve);
    }

    private synchronized Class<?> loadClassLocalFirst(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader cl;
        Class<?> c = this.findLoadedClass(name);
        if (c == null && (cl = this.initSystemClassLoader()) != null) {
            try {
                c = cl.loadClass(name);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        if (c == null) {
            ClassLoader p = this.getParent();
            boolean jppfCL = p instanceof AbstractJPPFClassLoader;
            if (!jppfCL) {
                try {
                    c = p.loadClass(name);
                }
                catch (ClassNotFoundException ignore) {}
            } else {
                c = ((AbstractJPPFClassLoader)p).findClassInURLClasspath(name, false);
            }
            if (c == null) {
                c = this.findClassInURLClasspath(name, false);
            }
            if (c == null && jppfCL) {
                try {
                    c = ((AbstractJPPFClassLoader)p).findClass(name, false);
                }
                catch (ClassNotFoundException ignore) {
                    // empty catch block
                }
            }
            if (c == null) {
                c = this.findClass(name, false);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected synchronized ClassLoader initSystemClassLoader() {
        block3: {
            if (!this.systemClassLoaderInitialized) {
                this.systemClassLoaderInitialized = true;
                try {
                    this.systemClassLoader = AbstractJPPFClassLoader.getSystemClassLoader();
                }
                catch (Exception e) {
                    if (!debugEnabled) break block3;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.systemClassLoader;
    }

    protected synchronized Class<?> findClassInURLClasspath(String name, boolean recursive) {
        Class<?> c;
        if (debugEnabled) {
            log.debug(StringUtils.build("looking up up resource [", name, "] in the URL classpath for ", this));
        }
        if ((c = this.findLoadedClass(name)) == null) {
            if (recursive && this.getParent() instanceof AbstractJPPFClassLoader) {
                c = ((AbstractJPPFClassLoader)this.getParent()).findClassInURLClasspath(name, recursive);
            }
            if (c == null) {
                try {
                    c = super.findClass(name);
                }
                catch (ClassNotFoundException ignore) {
                    // empty catch block
                }
            }
        }
        if (debugEnabled) {
            log.debug(StringUtils.build("resource [", name, "] ", c == null ? "not " : "", "found in the URL classpath for ", this));
        }
        return c;
    }

    public static synchronized DelegationModel getDelegationModel() {
        return delegationModel;
    }

    public static synchronized void setDelegationModel(DelegationModel model) {
        if (model != null) {
            delegationModel = model;
        }
    }

    private static synchronized DelegationModel initDelegationModel() {
        DelegationModel model;
        String s = JPPFConfiguration.getProperties().getString("jppf.classloader.delegation", "parent");
        DelegationModel delegationModel = model = "url".equalsIgnoreCase(s) ? DelegationModel.URL_FIRST : DelegationModel.PARENT_FIRST;
        if (debugEnabled) {
            log.debug(StringUtils.build(new Object[]{"Using ", model, " class loader delegation model"}));
        }
        return model;
    }

    public void clearNotFoundCache() {
        this.nfCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOCK.lock();
        try {
            this.cache.close();
            this.nfCache.clear();
        }
        finally {
            LOCK.unlock();
        }
    }
}

