/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.swarm.executors;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.swarm.SwarmNodeMessage;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;

public class RouterOut
implements Callable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Job job = null;

    public RouterOut(Job job) {
        this.job = job;
    }

    @Override
    public Boolean call() throws Exception {
        HazelcastInstance hazelcastInstance = SharedObjects.getInstance().getLocalMember();
        if (hazelcastInstance == null || !hazelcastInstance.getLifecycleService().isRunning()) {
            throw new Exception(SwarmNodeMessage.JEMO008E.toMessage().getFormattedMessage(new Object[]{this.job}));
        }
        IMap routedQueue = hazelcastInstance.getMap("org.pepstock.jem.routed");
        if (!this.job.isNowait()) {
            routedQueue.put((Object)this.job.getRoutingInfo().getId(), (Object)this.job);
            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO013I, new Object[]{this.job});
        }
        ITopic topic = hazelcastInstance.getTopic("org.pepstock.jem.job.ended");
        topic.publish((Object)this.job);
        return true;
    }
}

