/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.swarm;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.query.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.swarm.MapSwarmNodePredicate;
import org.pepstock.jem.gwt.server.swarm.MapSwarmNodesManager;
import org.pepstock.jem.gwt.server.swarm.SwarmNodeMessage;
import org.pepstock.jem.gwt.server.swarm.executors.RouterIn;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.JobComparator;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.RoutingQueuePredicate;
import org.pepstock.jem.node.Status;

public class RoutingQueueManager
implements EntryListener<String, Job> {
    private JobComparator comparator = new JobComparator();
    private boolean routeEnded = true;

    public RoutingQueueManager() {
        IMap routingQueue = SharedObjects.getInstance().getLocalMember().getMap("org.pepstock.jem.routing");
        routingQueue.addEntryListener((EntryListener)this, true);
    }

    public void entryAdded(EntryEvent<String, Job> event) {
        if (SharedObjects.getInstance().getMainSwarm().getStatus().equals((Object)Status.ACTIVE) && ((Job)event.getValue()).getRoutingInfo().isRoutingCommitted() == null && !((Job)event.getValue()).getJcl().isHold()) {
            this.routeJob((Job)event.getValue());
        }
    }

    public void entryEvicted(EntryEvent<String, Job> event) {
    }

    public void entryRemoved(EntryEvent<String, Job> event) {
        LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO012I, new Object[]{event.getValue()});
    }

    public void entryUpdated(EntryEvent<String, Job> event) {
        if (SharedObjects.getInstance().getMainSwarm().getStatus().equals((Object)Status.ACTIVE) && ((Job)event.getValue()).getRoutingInfo().isRoutingCommitted() == null && !((Job)event.getValue()).getJcl().isHold()) {
            this.routeJob((Job)event.getValue());
        }
    }

    public synchronized void routeJobsByAvailableEnvironments() {
        IMap nodesMap;
        Collection nodes;
        if (SharedObjects.getInstance().getMainSwarm().getStatus().equals((Object)Status.ACTIVE) && (nodes = (nodesMap = SharedObjects.getInstance().getMainSwarm().getHazelcastInstance().getMap("org.pepstock.jem.swarm.nodes")).values()) != null && nodes.size() > 0) {
            HashSet<String> environments = new HashSet<String>();
            Iterator nodesiter = nodes.iterator();
            while (nodesiter.hasNext()) {
                environments.add(((NodeInfo)nodesiter.next()).getExecutionEnvironment().getEnvironment());
            }
            IMap routingQueue = SharedObjects.getInstance().getLocalMember().getMap("org.pepstock.jem.routing");
            RoutingQueuePredicate rqp = new RoutingQueuePredicate();
            rqp.setEnvironments(environments);
            Collection jobs = routingQueue.values((Predicate)rqp);
            ArrayList queuedJobs = new ArrayList(jobs);
            Collections.sort(queuedJobs, this.comparator);
            for (Job currJob : queuedJobs) {
                this.routeJob(currJob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void routeJob(Job job) {
        if (SharedObjects.getInstance().getMainSwarm().getStatus().equals((Object)Status.ACTIVE)) {
            this.setRouteEnded(false);
            IMap routingQueue = SharedObjects.getInstance().getLocalMember().getMap("org.pepstock.jem.routing");
            IMap nodesMap = SharedObjects.getInstance().getMainSwarm().getHazelcastInstance().getMap("org.pepstock.jem.swarm.nodes");
            try {
                routingQueue.lock((Object)job.getId());
                job = (Job)routingQueue.get((Object)job.getId());
                if (job != null && job.getRoutingInfo().isRoutingCommitted() == null) {
                    MapSwarmNodePredicate mnp = new MapSwarmNodePredicate();
                    mnp.setEnvironment(job.getJcl().getEnvironment());
                    Member member = MapSwarmNodesManager.getMember(nodesMap.values((Predicate)mnp));
                    if (member != null) {
                        LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO009I, new Object[]{job});
                        DistributedTask task = new DistributedTask((Callable)new RouterIn(job, SharedObjects.getInstance().getInfo().getExecutionEnvironment().getEnvironment()), member);
                        ExecutorService executorService = SharedObjects.getInstance().getMainSwarm().getHazelcastInstance().getExecutorService();
                        job.getRoutingInfo().setRoutingCommitted(Boolean.valueOf(false));
                        routingQueue.put((Object)job.getId(), (Object)job);
                        executorService.execute((Runnable)task);
                        if (((Boolean)task.get()).booleanValue()) {
                            routingQueue.remove((Object)job.getId());
                            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO010I, new Object[]{job});
                        }
                    }
                }
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO011E, new Object[]{job, e});
            }
            finally {
                if (routingQueue != null) {
                    routingQueue.unlock((Object)job.getId());
                }
            }
            this.setRouteEnded(true);
        }
    }

    public boolean isRouteEnded() {
        return this.routeEnded;
    }

    private void setRouteEnded(boolean routeEnded) {
        this.routeEnded = routeEnded;
    }
}

