/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.swarm;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.query.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.swarm.MapSwarmNodePredicate;
import org.pepstock.jem.gwt.server.swarm.MapSwarmNodesManager;
import org.pepstock.jem.gwt.server.swarm.SwarmNodeMessage;
import org.pepstock.jem.gwt.server.swarm.executors.RouterOut;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.JobComparator;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.OutputQueuePredicate;
import org.pepstock.jem.node.Status;

public class OutputQueueManager
implements EntryListener<String, Job> {
    private JobComparator comparator = new JobComparator();
    private boolean notifyOutputEnded = true;

    public OutputQueueManager() {
        IMap routingQueue = SharedObjects.getInstance().getLocalMember().getMap("org.pepstock.jem.output");
        routingQueue.addEntryListener((EntryListener)this, true);
    }

    public void entryAdded(EntryEvent<String, Job> event) {
        Job job;
        if (SharedObjects.getInstance().getMainSwarm().getStatus().equals((Object)Status.ACTIVE) && (job = (Job)event.getValue()).getRoutingInfo().getEnvironment() != null) {
            this.notifyEndedRoutedJob(job);
        }
    }

    public void entryEvicted(EntryEvent<String, Job> event) {
    }

    public void entryRemoved(EntryEvent<String, Job> event) {
    }

    public void entryUpdated(EntryEvent<String, Job> event) {
    }

    public synchronized void notifyEndedRoutedJobsByAvailableEnvironments() {
        IMap nodesMap;
        Collection nodes;
        if (SharedObjects.getInstance().getMainSwarm().getStatus().equals((Object)Status.ACTIVE) && (nodes = (nodesMap = SharedObjects.getInstance().getMainSwarm().getHazelcastInstance().getMap("org.pepstock.jem.swarm.nodes")).values()) != null && nodes.size() > 0) {
            HashSet<String> environments = new HashSet<String>();
            Iterator nodesiter = nodes.iterator();
            while (nodesiter.hasNext()) {
                String currEnv = ((NodeInfo)nodesiter.next()).getExecutionEnvironment().getEnvironment();
                if (currEnv.equalsIgnoreCase(SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName())) continue;
                environments.add(currEnv);
            }
            IMap routingQueue = SharedObjects.getInstance().getLocalMember().getMap("org.pepstock.jem.output");
            OutputQueuePredicate oqp = new OutputQueuePredicate();
            oqp.setEnvironments(environments);
            Collection jobs = routingQueue.values((Predicate)oqp);
            ArrayList queuedJobs = new ArrayList(jobs);
            Collections.sort(queuedJobs, this.comparator);
            for (Job currJob : queuedJobs) {
                this.notifyEndedRoutedJob(currJob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void notifyEndedRoutedJob(Job job) {
        if (SharedObjects.getInstance().getMainSwarm().getStatus().equals((Object)Status.ACTIVE)) {
            this.setNotifyOutputEnded(false);
            IMap outputQueue = SharedObjects.getInstance().getLocalMember().getMap("org.pepstock.jem.output");
            IMap nodesMap = SharedObjects.getInstance().getMainSwarm().getHazelcastInstance().getMap("org.pepstock.jem.swarm.nodes");
            try {
                outputQueue.lock((Object)job.getId());
                job = (Job)outputQueue.get((Object)job.getId());
                if (job != null && job.getRoutingInfo().isOutputCommitted() == null) {
                    MapSwarmNodePredicate mnp = new MapSwarmNodePredicate();
                    mnp.setEnvironment(job.getRoutingInfo().getEnvironment());
                    Member member = MapSwarmNodesManager.getMember(nodesMap.values((Predicate)mnp));
                    if (member != null) {
                        LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO006I, new Object[]{job});
                        DistributedTask task = new DistributedTask((Callable)new RouterOut(job), member);
                        ExecutorService executorService = SharedObjects.getInstance().getMainSwarm().getHazelcastInstance().getExecutorService();
                        job.getRoutingInfo().setOutputCommitted(false);
                        outputQueue.put((Object)job.getId(), (Object)job);
                        executorService.execute((Runnable)task);
                        if (((Boolean)task.get()).booleanValue()) {
                            job.getRoutingInfo().setOutputCommitted(true);
                            outputQueue.put((Object)job.getId(), (Object)job);
                            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO007I, new Object[]{job});
                        }
                    }
                }
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO005E, new Object[]{job, e});
            }
            finally {
                if (outputQueue != null) {
                    outputQueue.unlock((Object)job.getId());
                }
            }
            this.setNotifyOutputEnded(true);
        }
    }

    public boolean isNotifyOutputEnded() {
        return this.notifyOutputEnded;
    }

    private void setNotifyOutputEnded(boolean notifyOutputEnded) {
        this.notifyOutputEnded = notifyOutputEnded;
    }
}

