/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.Permission;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.InternalsManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.executors.GetRealtimeSample;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.node.stats.LightSample;
import org.pepstock.jem.node.stats.SampleComparator;
import org.pepstock.jem.util.DateFormatter;

public class StatisticsManager
extends InternalsManager {
    private SampleComparator sampleComparator = new SampleComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LightSample> getSamples() throws Exception {
        try {
            this.checkAuthorization((Permission)new StringPermission("administration:cluster:folder"));
        }
        catch (Exception e) {
            try {
                this.checkAuthorization((Permission)new StringPermission("administration:nodes:folder"));
            }
            catch (Exception e1) {
                this.checkAuthorization((Permission)new StringPermission("administration:queues:folder"));
            }
        }
        IMap samples = this.getInstance().getMap("org.pepstock.jem.stats");
        ArrayList<LightSample> list = null;
        try {
            samples.lockMap(10L, TimeUnit.SECONDS);
            list = new ArrayList<LightSample>(samples.values());
            Collections.sort(list, this.sampleComparator);
        }
        finally {
            samples.unlockMap();
        }
        return list;
    }

    public LightSample getCurrentSample() throws Exception {
        try {
            this.checkAuthorization((Permission)new StringPermission("administration:cluster:folder"));
        }
        catch (Exception e) {
            try {
                this.checkAuthorization((Permission)new StringPermission("administration:nodes:folder"));
            }
            catch (Exception e1) {
                this.checkAuthorization((Permission)new StringPermission("administration:queues:folder"));
            }
        }
        LightSample lightSample = null;
        Cluster cluster = this.getInstance().getCluster();
        HashSet<Member> listOfNodes = new HashSet<Member>();
        for (Member member : cluster.getMembers()) {
            if (member.isLiteMember()) continue;
            listOfNodes.add(member);
        }
        if (!listOfNodes.isEmpty()) {
            String key = DateFormatter.getCurrentDate((String)"yyyy-MM-dd HH:mm");
            String[] times = StringUtils.split((String)key, (char)' ');
            lightSample = new LightSample();
            lightSample.setKey(key);
            lightSample.setDate(times[0]);
            lightSample.setTime(times[1]);
            MultiTask task = new MultiTask((Callable)new GetRealtimeSample(lightSample), listOfNodes);
            ExecutorService executorService = this.getInstance().getExecutorService();
            executorService.execute((Runnable)task);
            try {
                Collection results = task.get();
                lightSample.getMembers().addAll(results);
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG018E, (Throwable)e);
            }
        }
        return lightSample;
    }
}

