/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.Subject;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.node.security.User;
import org.pepstock.jem.util.filters.Filter;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.fields.RoleFilterFields;
import org.pepstock.jem.util.filters.predicates.RolePredicate;

public class RolesManager
extends DefaultService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Role> getRoles(String filter) throws Exception {
        RolePredicate predicate;
        this.checkAuthorization((Permission)new StringPermission("roles:read"));
        IMap roles = this.getInstance().getMap("org.pepstock.jem.roles");
        try {
            predicate = new RolePredicate(Filter.parse((String)filter));
        }
        catch (Exception e) {
            Filter all = new Filter();
            all.add(new FilterToken(RoleFilterFields.NAME.getName(), ""));
            predicate = new RolePredicate(all);
        }
        ArrayList<Role> list = null;
        if (roles.lockMap(10L, TimeUnit.SECONDS)) {
            try {
                list = new ArrayList<Role>(roles.values((Predicate)predicate));
            }
            finally {
                roles.unlockMap();
            }
        } else {
            throw new Exception(UserInterfaceMessage.JEMG022E.toMessage().getFormattedMessage(new Object[]{"org.pepstock.jem.roles"}));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean addRole(Role role) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("roles:create"));
        IMap roles = this.getInstance().getMap("org.pepstock.jem.roles");
        if (roles.containsKey((Object)role.getName())) {
            throw new Exception(UserInterfaceMessage.JEMG026E.toMessage().getFormattedMessage(new Object[]{role.getName()}));
        }
        try {
            roles.lock((Object)role.getName());
            Subject currentUser = SecurityUtils.getSubject();
            User userPrincipal = (User)currentUser.getPrincipal();
            String userId = userPrincipal.getId();
            role.setUser(userId);
            role.setLastModified(new Date());
            roles.put((Object)role.getName(), (Object)role);
        }
        finally {
            roles.unlock((Object)role.getName());
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean updateRole(Role role) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("roles:update"));
        IMap roles = this.getInstance().getMap("org.pepstock.jem.roles");
        if (!roles.containsKey((Object)role.getName())) {
            throw new Exception(UserInterfaceMessage.JEMG027E.toMessage().getFormattedMessage(new Object[]{role.getName()}));
        }
        try {
            roles.lock((Object)role.getName());
            Role oldRole = (Role)roles.get((Object)role.getName());
            if (oldRole.getUser() != null && !oldRole.getUser().equalsIgnoreCase(role.getUser())) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG047E, new Object[]{oldRole, role});
                throw new Exception(UserInterfaceMessage.JEMG047E.toMessage().getFormattedMessage(new Object[]{oldRole, role}));
            }
            if (oldRole.getLastModified() != null && !oldRole.getLastModified().equals(role.getLastModified())) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG047E, new Object[]{oldRole, role});
                throw new Exception(UserInterfaceMessage.JEMG047E.toMessage().getFormattedMessage(new Object[]{oldRole, role}));
            }
            Subject currentUser = SecurityUtils.getSubject();
            User userPrincipal = (User)currentUser.getPrincipal();
            String userId = userPrincipal.getId();
            role.setUser(userId);
            role.setLastModified(new Date());
            roles.replace((Object)role.getName(), (Object)role);
        }
        finally {
            roles.unlock((Object)role.getName());
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean removeRole(Collection<Role> roles) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("roles:delete"));
        IMap map = this.getInstance().getMap("org.pepstock.jem.roles");
        for (Role role : roles) {
            if (!role.isRemovable() || !map.containsKey((Object)role.getName())) continue;
            try {
                map.lock((Object)role.getName());
                map.remove((Object)role.getName());
            }
            finally {
                map.unlock((Object)role.getName());
            }
        }
        return Boolean.TRUE;
    }
}

