/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.security;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.security.Authorizator;
import org.pepstock.jem.gwt.server.security.FirstInstallationManager;
import org.pepstock.jem.gwt.server.security.FirstInstallationToken;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.security.PrincipalAttribute;
import org.pepstock.jem.node.security.User;

public class ExtendedJndiLdapRealm
extends JndiLdapRealm {
    private static final String UID = "uid";
    private Authorizator authorizator = null;
    private SearchControls ctls = new SearchControls();
    private Hashtable<String, String> principalEnvironment = null;
    private String[] attributes = null;
    private String orgUnitIdAttribute = null;
    private String orgUnitNameAttribute = null;
    private String userNameAttribute = null;
    private String firstInstallationUserid = null;

    public ExtendedJndiLdapRealm() {
        this.ctls.setSearchScope(2);
        this.authorizator = new Authorizator();
    }

    public String getOrgUnitIdAttribute() {
        return this.orgUnitIdAttribute;
    }

    public void setOrgUnitIdAttribute(String orgUnitIdAttribute) {
        this.orgUnitIdAttribute = orgUnitIdAttribute;
    }

    public String getOrgUnitNameAttribute() {
        return this.orgUnitNameAttribute;
    }

    public void setOrgUnitNameAttribute(String orgUnitNameAttribute) {
        this.orgUnitNameAttribute = orgUnitNameAttribute;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public String[] getAttributes() {
        return (String[])this.attributes.clone();
    }

    public void setAttributes(String[] attributes) {
        this.attributes = (String[])attributes.clone();
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public String getFirstInstallationUserid() {
        return this.firstInstallationUserid;
    }

    public void setFirstInstallationUserid(String firstInstallationUserid) {
        this.firstInstallationUserid = firstInstallationUserid;
    }

    protected void onInit() {
        super.onInit();
        FirstInstallationManager manager = FirstInstallationManager.getInstance();
        manager.setToken(new FirstInstallationToken(this.getFirstInstallationUserid(), null));
    }

    protected AuthenticationInfo createAuthenticationInfo(AuthenticationToken token, Object ldapPrincipal, Object ldapCredentials, LdapContext ldapContext) throws NamingException {
        if (token instanceof FirstInstallationToken) {
            FirstInstallationToken upToken = (FirstInstallationToken)token;
            User user = new User(upToken.getUsername());
            SimpleAccount account = new SimpleAccount((Object)user, ldapCredentials, this.getName());
            return account;
        }
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        List<PrincipalAttribute> principals = null;
        try {
            if (this.principalEnvironment == null) {
                LdapContext context = super.getContextFactory().getSystemLdapContext();
                Hashtable<?, ?> currentEnvironment = context.getEnvironment();
                this.principalEnvironment = (Hashtable)currentEnvironment.clone();
                this.principalEnvironment.put("java.naming.security.authentication", "none");
            }
            principals = this.search(upToken.getUsername(), this.principalEnvironment);
        }
        catch (NamingException e) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG031E, (Throwable)e, new Object[]{upToken.getUsername()});
        }
        User user = new User(upToken.getUsername());
        user.setAttributes(principals);
        if (principals != null) {
            for (PrincipalAttribute pa : principals) {
                if (this.orgUnitIdAttribute != null && pa.getName().equalsIgnoreCase(this.orgUnitIdAttribute)) {
                    user.setOrgUnitId(pa.getValue().toString());
                }
                if (this.orgUnitNameAttribute != null && pa.getName().equalsIgnoreCase(this.orgUnitNameAttribute)) {
                    user.setOrgUnitName(pa.getValue().toString());
                }
                if (this.userNameAttribute == null || !pa.getName().equalsIgnoreCase(this.userNameAttribute)) continue;
                user.setName(pa.getValue().toString());
            }
        }
        SimpleAccount account = new SimpleAccount((Object)user, token.getCredentials(), this.getName());
        return account;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        try {
            return this.authorizator.doGetAuthorizationInfo((Realm)this, principals);
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
    }

    public List<PrincipalAttribute> search(String id, Hashtable<String, String> environment) {
        if (this.attributes != null && this.attributes.length > 0) {
            this.ctls.setReturningAttributes(this.attributes);
        }
        if (this.ctls.getReturningAttributes() == null) {
            this.ctls.setReturningAttributes(new String[]{UID});
        }
        String userDn = super.getUserDnTemplate();
        String ldapUserContext = StringUtils.substringAfter((String)userDn, (String)",");
        try {
            NamingEnumeration<SearchResult> obj;
            InitialDirContext ctx = new InitialDirContext(environment);
            String filter = MessageFormat.format("(uid={0})", id);
            NamingEnumeration<SearchResult> userEnum = obj = ctx.search(ldapUserContext, filter, this.ctls);
            if (userEnum != null && userEnum.hasMore()) {
                SearchResult result = userEnum.next();
                return this.loadAttributes(id, result.getAttributes());
            }
        }
        catch (NamingException ne) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG031E, (Throwable)ne, new Object[]{id});
        }
        return new ArrayList<PrincipalAttribute>();
    }

    private List<PrincipalAttribute> loadAttributes(String id, Attributes attributes) {
        ArrayList<PrincipalAttribute> list = new ArrayList<PrincipalAttribute>();
        if (attributes != null) {
            try {
                NamingEnumeration<? extends Attribute> attrEnum = attributes.getAll();
                while (attrEnum.hasMore()) {
                    Attribute attribute = attrEnum.next();
                    NamingEnumeration<?> valueEnum = attribute.getAll();
                    while (valueEnum.hasMore()) {
                        PrincipalAttribute attr = new PrincipalAttribute();
                        attr.setName(attribute.getID());
                        attr.setValue(valueEnum.next());
                        list.add(attr);
                    }
                }
            }
            catch (NamingException e) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG031E, (Throwable)e, new Object[]{id});
            }
        }
        return list;
    }
}

