/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.rest;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.pepstock.jem.gwt.client.security.LoggedUser;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.rest.DefaultServerResource;
import org.pepstock.jem.gwt.server.rest.entities.Account;
import org.pepstock.jem.gwt.server.rest.entities.LoggedUserContent;
import org.pepstock.jem.gwt.server.services.LoginManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;

@Path(value="/loginManager")
public class LoginManagerImpl
extends DefaultServerResource {
    public static final String LOGIN_MANAGER_PATH = "loginManager";
    public static final String LOGIN_MANAGER_GET_USER_PATH = "getUser";
    public static final String LOGIN_MANAGER_LOGIN_PATH = "login";
    public static final String LOGIN_MANAGER_LOGOFF_PATH = "logoff";
    private LoginManager loginManager = null;

    @GET
    @Path(value="/getUser")
    @Produces(value={"application/xml", "application/json"})
    public LoggedUserContent getUser() throws Exception {
        LoggedUserContent content = new LoggedUserContent();
        if (this.isEnable()) {
            if (this.loginManager == null) {
                this.initManager();
            }
            LoggedUser user = this.loginManager.getUser();
            content.setLoggedUser(user);
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            content.setExceptionMessage(msg);
        }
        return content;
    }

    @PUT
    @Path(value="/login")
    @Produces(value={"application/xml", "application/json"})
    public LoggedUserContent login(Account account) throws Exception {
        LoggedUserContent content = new LoggedUserContent();
        if (this.isEnable()) {
            if (this.loginManager == null) {
                this.initManager();
            }
            try {
                LoggedUser user = this.loginManager.login(account.getUserid(), account.getPassword());
                content.setLoggedUser(user);
            }
            catch (Exception e) {
                content.setExceptionMessage(e.getMessage());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            content.setExceptionMessage(msg);
        }
        return content;
    }

    @DELETE
    @Path(value="/logoff")
    public void logoff() throws Exception {
        if (this.loginManager != null) {
            this.loginManager.logoff(null);
        }
    }

    private synchronized void initManager() {
        if (this.loginManager == null) {
            this.loginManager = new LoginManager();
        }
    }
}

