/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.rest;

import java.util.Collection;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.OutputTree;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.rest.DefaultServerResource;
import org.pepstock.jem.gwt.server.rest.entities.JobId;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputFileContent;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputListArgument;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputTreeContent;
import org.pepstock.jem.gwt.server.rest.entities.Jobs;
import org.pepstock.jem.gwt.server.rest.entities.ReturnedObject;
import org.pepstock.jem.gwt.server.services.JobsManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;

@Path(value="/jobs")
public class JobsManagerImpl
extends DefaultServerResource {
    public static final String JOBS_MANAGER_PATH = "jobs";
    public static final String JOBS_MANAGER_INPUT_PATH = "input";
    public static final String JOBS_MANAGER_RUNNING_PATH = "running";
    public static final String JOBS_MANAGER_OUTPUT_PATH = "output";
    public static final String JOBS_MANAGER_ROUTING_PATH = "routing";
    public static final String JOBS_MANAGER_HOLD_PATH = "hold";
    public static final String JOBS_MANAGER_RELEASE_PATH = "release";
    public static final String JOBS_MANAGER_SUBMIT_PATH = "submit";
    public static final String JOBS_MANAGER_OUTPUT_TREE_PATH = "outputTree";
    public static final String JOBS_MANAGER_OUTPUT_FILE_CONTENT_PATH = "outputFileContent";
    private JobsManager jobsManager = null;

    @POST
    @Path(value="/input")
    @Produces(value={"application/xml", "application/json"})
    public Jobs getInputQueue(String jobNameFilter) throws Exception {
        Jobs jobsContainer = new Jobs();
        if (this.isEnable()) {
            if (this.jobsManager == null) {
                this.initManager();
            }
            try {
                Collection<Job> jobs = this.jobsManager.getInputQueue(jobNameFilter);
                jobsContainer.setJobs(jobs);
                jobsContainer.setQueueName("org.pepstock.jem.input");
            }
            catch (Exception e) {
                jobsContainer.setExceptionMessage(e.getMessage());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            jobsContainer.setExceptionMessage(msg);
        }
        return jobsContainer;
    }

    @POST
    @Path(value="/running")
    @Produces(value={"application/xml", "application/json"})
    public Jobs getRunningQueue(String jobNameFilter) throws Exception {
        Jobs jobsContainer = new Jobs();
        if (this.isEnable()) {
            if (this.jobsManager == null) {
                this.initManager();
            }
            try {
                Collection<Job> jobs = this.jobsManager.getRunningQueue(jobNameFilter);
                jobsContainer.setJobs(jobs);
                jobsContainer.setQueueName("org.pepstock.jem.running");
            }
            catch (Exception e) {
                jobsContainer.setExceptionMessage(e.getMessage());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            jobsContainer.setExceptionMessage(msg);
        }
        return jobsContainer;
    }

    @POST
    @Path(value="/output")
    @Produces(value={"application/xml", "application/json"})
    public Jobs getOutputQueue(String jobNameFilter) throws Exception {
        Jobs jobsContainer = new Jobs();
        if (this.isEnable()) {
            if (this.jobsManager == null) {
                this.initManager();
            }
            try {
                Collection<Job> jobs = this.jobsManager.getOutputQueue(jobNameFilter);
                jobsContainer.setJobs(jobs);
                jobsContainer.setQueueName("org.pepstock.jem.output");
            }
            catch (Exception e) {
                jobsContainer.setExceptionMessage(e.getMessage());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            jobsContainer.setExceptionMessage(msg);
        }
        return jobsContainer;
    }

    @POST
    @Path(value="/routing")
    @Produces(value={"application/xml", "application/json"})
    public Jobs getRoutingQueue(String jobNameFilter) throws Exception {
        Jobs jobsContainer = new Jobs();
        if (this.isEnable()) {
            if (this.jobsManager == null) {
                this.initManager();
            }
            try {
                Collection<Job> jobs = this.jobsManager.getRoutingQueue(jobNameFilter);
                jobsContainer.setJobs(jobs);
                jobsContainer.setQueueName("org.pepstock.jem.routing");
            }
            catch (Exception e) {
                jobsContainer.setExceptionMessage(e.getMessage());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            jobsContainer.setExceptionMessage(msg);
        }
        return jobsContainer;
    }

    @POST
    @Path(value="/hold")
    @Produces(value={"application/xml", "application/json"})
    public ReturnedObject hold(Jobs jobs) throws Exception {
        ReturnedObject ro = new ReturnedObject();
        if (this.isEnable()) {
            if (jobs.getQueueName() != null && !jobs.getJobs().isEmpty()) {
                if (this.jobsManager == null) {
                    this.initManager();
                }
                this.jobsManager.hold(jobs.getJobs(), jobs.getQueueName());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            ro.setExceptionMessage(msg);
        }
        return ro;
    }

    @POST
    @Path(value="/release")
    @Produces(value={"application/xml", "application/json"})
    public ReturnedObject release(Jobs jobs) throws Exception {
        ReturnedObject ro = new ReturnedObject();
        if (this.isEnable()) {
            if (jobs.getQueueName() != null && !jobs.getJobs().isEmpty()) {
                if (this.jobsManager == null) {
                    this.initManager();
                }
                this.jobsManager.release(jobs.getJobs(), jobs.getQueueName());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            ro.setExceptionMessage(msg);
        }
        return ro;
    }

    @POST
    @Path(value="/submit")
    @Produces(value={"application/xml", "application/json"})
    public JobId submit(PreJob preJob) throws Exception {
        JobId jobid = new JobId();
        if (this.isEnable()) {
            if (this.jobsManager == null) {
                this.initManager();
            }
            try {
                String id = this.jobsManager.submit(preJob);
                jobid.setId(id);
            }
            catch (Exception e) {
                jobid.setExceptionMessage(e.getMessage());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            jobid.setExceptionMessage(msg);
        }
        return jobid;
    }

    @POST
    @Path(value="/outputTree")
    @Produces(value={"application/xml", "application/json"})
    public JobOutputTreeContent getOutputTree(Jobs jobs) throws Exception {
        JobOutputTreeContent content = new JobOutputTreeContent();
        if (this.isEnable()) {
            if (jobs.getQueueName() != null && jobs.getJobs().size() == 1) {
                if (this.jobsManager == null) {
                    this.initManager();
                }
                Job job = jobs.getJobs().iterator().next();
                OutputTree tree = this.jobsManager.getOutputTree(job, jobs.getQueueName());
                content.setJclContent(tree.getJclContent());
                content.setFirstLevelItems(tree.getFirstLevelItems());
                content.setJob(job);
                content.setSecondLevelItems(tree.getSecondLevelItems());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            content.setExceptionMessage(msg);
        }
        return content;
    }

    @POST
    @Path(value="/outputFileContent")
    @Produces(value={"application/xml", "application/json"})
    public JobOutputFileContent getOutputFileContent(JobOutputListArgument jobFileContent) throws Exception {
        JobOutputFileContent content = new JobOutputFileContent();
        if (this.isEnable()) {
            if (this.jobsManager == null) {
                this.initManager();
            }
            OutputFileContent fileContent = this.jobsManager.getOutputFileContent(jobFileContent.getJob(), jobFileContent.getItem());
            content.setJob(jobFileContent.getJob());
            content.setOutputFileContent(fileContent);
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            content.setExceptionMessage(msg);
        }
        return content;
    }

    private synchronized void initManager() {
        if (this.jobsManager == null) {
            this.jobsManager = new JobsManager();
        }
    }
}

