/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.listeners;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.Set;
import org.pepstock.jem.gwt.server.commons.NodeInfoUtility;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.node.NodeInfo;

public class NodeListener
implements MembershipListener {
    public void memberAdded(MembershipEvent event) {
        Member member = event.getMember();
        if (!SharedObjects.getInstance().isDataClusterAvailable() && !member.isLiteMember()) {
            SharedObjects.getInstance().setDataClusterAvailable(true);
            NodeInfo info = SharedObjects.getInstance().getInfo();
            NodeInfoUtility.checkAndStoreNodeInfo(info);
        }
    }

    public void memberRemoved(MembershipEvent event) {
        Member memberRemoved = event.getMember();
        if (memberRemoved.isLiteMember()) {
            return;
        }
        Cluster cluster = SharedObjects.getInstance().getLocalMember().getCluster();
        Set setMembers = cluster.getMembers();
        for (Member member : setMembers) {
            if (member.isLiteMember()) continue;
            SharedObjects.getInstance().setDataClusterAvailable(true);
            return;
        }
        SharedObjects.getInstance().setDataClusterAvailable(false);
    }
}

