/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.commons;

import com.hazelcast.core.HazelcastInstance;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.swarm.MainSwarm;
import org.pepstock.jem.gwt.server.swarm.SwarmNodeMessage;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeInfo;

public class SharedObjects {
    private static SharedObjects SHARED_OBJECTS = null;
    private NodeInfo info = null;
    private boolean isDataClusterAvailable = false;
    private HazelcastInstance localMember = null;
    private String sessionsInstance = null;
    private MainSwarm main = new MainSwarm();
    private Boolean checkVersion = false;
    private String jemVersion = "Unknown";

    public static synchronized SharedObjects createInstance() {
        if (SHARED_OBJECTS == null) {
            SHARED_OBJECTS = new SharedObjects();
        }
        return SHARED_OBJECTS;
    }

    public static SharedObjects getInstance() {
        return SHARED_OBJECTS;
    }

    private SharedObjects() {
    }

    public void setInfo(NodeInfo info) {
        this.info = info;
    }

    public NodeInfo getInfo() {
        return this.info;
    }

    public void setDataClusterAvailable(boolean isDataClusterAvailable) {
        boolean mustBeStarted = isDataClusterAvailable && !this.isDataClusterAvailable;
        boolean mustBeShuttedDown = !isDataClusterAvailable && this.isDataClusterAvailable;
        this.isDataClusterAvailable = isDataClusterAvailable;
        if (isDataClusterAvailable) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG004I, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            if (mustBeStarted) {
                try {
                    this.main.start();
                }
                catch (Exception e) {
                    LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO015E, (Throwable)e);
                }
            }
            if (mustBeShuttedDown) {
                try {
                    this.main.shutDown();
                }
                catch (Exception e) {
                    LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO015E, (Throwable)e);
                }
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG005E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
        }
    }

    public boolean isDataClusterAvailable() {
        return this.isDataClusterAvailable;
    }

    public void shutdownLocalMember() {
        if (this.localMember != null) {
            this.localMember.getLifecycleService().shutdown();
            this.localMember = null;
        }
    }

    public HazelcastInstance getLocalMember() {
        return this.localMember;
    }

    public void setLocalMember(HazelcastInstance localMember) {
        this.localMember = localMember;
    }

    public String getSessionsInstance() {
        return this.sessionsInstance;
    }

    public void setSessionsInstance(String sessionsInstance) {
        this.sessionsInstance = sessionsInstance;
    }

    public MainSwarm getMainSwarm() {
        return this.main;
    }

    public Boolean getCheckVersion() {
        return this.checkVersion;
    }

    public void setCheckVersion(Boolean checkVersion) {
        this.checkVersion = checkVersion;
    }

    public String getJemVersion() {
        return this.jemVersion;
    }

    public void setJemVersion(String jemVersion) {
        this.jemVersion = jemVersion;
    }
}

