/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.commons;

import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.ExecutionEnvironment;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.Status;

public class NodeInfoUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NodeInfo createNodeInfo(Member member, String contextPath) {
        NodeInfo info = new NodeInfo();
        info.setKey(member.getUuid());
        info.setStatus(Status.STARTING);
        info.setSuperNode(member.isLiteMember());
        InetSocketAddress address = member.getInetSocketAddress();
        info.setPort(address.getPort());
        info.setIpaddress(address.getAddress().getHostAddress());
        info.setHostname(address.getHostName());
        info.setLabel(info.getIpaddress() + ":" + info.getPort());
        ExecutionEnvironment executionEnviroment = new ExecutionEnvironment();
        executionEnviroment.setEnvironment(SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName());
        info.setExecutionEnvironment(executionEnviroment);
        info.setProcessId(ManagementFactory.getRuntimeMXBean().getName());
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        info.getNodeInfoBean().setSystemArchitecture(bean.getArch());
        info.getNodeInfoBean().setAvailableProcessors(bean.getAvailableProcessors());
        info.getNodeInfoBean().setSystemName(bean.getName());
        File file = null;
        FileInputStream fis = null;
        try {
            file = new File(contextPath + "META-INF/MANIFEST.MF");
            fis = new FileInputStream(file);
            Manifest manifest = new Manifest(fis);
            Attributes at = manifest.getAttributes("JEM_the_BEE");
            String jemVersion = at.getValue("Jem_version");
            if (jemVersion != null) {
                info.setJemVersion(jemVersion);
                SharedObjects.getInstance().setJemVersion(jemVersion);
            }
        }
        catch (FileNotFoundException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC184W);
        }
        catch (IOException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC184W);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void checkAndStoreNodeInfo(NodeInfo info) {
        IMap members_map = SharedObjects.getInstance().getLocalMember().getMap("org.pepstock.jem.nodes");
        StringBuffer sb = new StringBuffer();
        sb.append("label = '").append(info.getLabel()).append("'");
        try {
            members_map.lock((Object)info.getKey());
            Collection nodeInfos = members_map.values((Predicate)new SqlPredicate(sb.toString()));
            if (!nodeInfos.isEmpty()) {
                for (NodeInfo prevNodeInfo : nodeInfos) {
                    members_map.remove((Object)prevNodeInfo.getKey());
                }
            }
            members_map.put((Object)info.getKey(), (Object)info);
            Collection allNodes = members_map.values();
            for (NodeInfo currNodeInfo : allNodes) {
                if (currNodeInfo.getJemVersion().equals(info.getJemVersion())) continue;
                if (SharedObjects.getInstance().getCheckVersion().booleanValue()) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC191E);
                    throw new RuntimeException(NodeMessage.JEMC191E.toMessage().getFormattedMessage(new Object[0]));
                }
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC185W);
                break;
            }
        }
        finally {
            members_map.unlock((Object)info.getKey());
        }
    }
}

