/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.util.Collection;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.services.SwarmManagerService;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.services.SwarmNodesManager;
import org.pepstock.jem.gwt.server.swarm.SwarmNodeMessage;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;

public class SwarmManagerServiceImpl
extends DefaultManager
implements SwarmManagerService {
    private static final long serialVersionUID = 1L;
    private transient SwarmNodesManager swarmNodesManager = null;

    @Override
    public Collection<NodeInfoBean> getNodes(String nodesFilter) throws Exception {
        this.checkIsEnable();
        if (this.swarmNodesManager == null) {
            this.initManager();
        }
        try {
            return this.swarmNodesManager.getNodes(nodesFilter);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO014I, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public Collection<NodeInfoBean> getNodesByFilter(String filterString) throws Exception {
        this.checkIsEnable();
        if (this.swarmNodesManager == null) {
            this.initManager();
        }
        try {
            return this.swarmNodesManager.getNodesByFilter(filterString);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO014I, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public Boolean start() throws Exception {
        this.checkIsEnable();
        if (this.swarmNodesManager == null) {
            this.initManager();
        }
        try {
            return this.swarmNodesManager.start();
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO014I, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public Boolean drain() throws Exception {
        this.checkIsEnable();
        if (this.swarmNodesManager == null) {
            this.initManager();
        }
        try {
            return this.swarmNodesManager.drain();
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO014I, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public String getStatus() throws Exception {
        this.checkIsEnable();
        if (this.swarmNodesManager == null) {
            this.initManager();
        }
        try {
            return this.swarmNodesManager.getStatus();
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO014I, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    private synchronized void initManager() throws Exception {
        if (this.swarmNodesManager == null) {
            try {
                this.swarmNodesManager = new SwarmNodesManager();
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO014I, (Throwable)ex);
                throw new Exception(ex.getMessage());
            }
        }
    }
}

