/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.IOUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.gwt.client.services.SubmitManagerService;
import org.pepstock.jem.gwt.server.FileUploadManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.JobsManager;

public class SubmitManagerServiceImpl
extends FileUploadManager
implements SubmitManagerService {
    private static final long serialVersionUID = 1L;

    @Override
    public String loaded(List<FileItem> items) throws Exception {
        JobsManager jobsManager = new JobsManager();
        String fileName = null;
        PreJob preJob = null;
        for (FileItem item : items) {
            if (item.getFieldName().equalsIgnoreCase("jcl")) {
                fileName = item.getName();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)item.getInputStream(), (Writer)writer);
                preJob = new PreJob();
                preJob.setJclContent(writer.toString());
                Job job = new Job();
                job.setInputArguments(ManagementFactory.getRuntimeMXBean().getInputArguments());
                preJob.setJob(job);
                continue;
            }
            if (!item.getFieldName().equalsIgnoreCase("type")) continue;
            String type = item.getString();
            preJob.setJclType(type);
        }
        if (preJob != null) {
            try {
                String id = jobsManager.submit(preJob);
                return UserInterfaceMessage.JEMG034I.toMessage().getFormattedMessage(new Object[]{fileName, id});
            }
            catch (Exception e) {
                throw new Exception(UserInterfaceMessage.JEMG048E.toMessage().getFormattedMessage(new Object[]{e.getMessage()}));
            }
        }
        throw new Exception(UserInterfaceMessage.JEMG035E.toMessage().getFormattedMessage(new Object[0]));
    }
}

