/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.util.Collection;
import org.pepstock.jem.gwt.client.services.StatisticsManagerService;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.StatisticsManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.persistence.RedoStatement;
import org.pepstock.jem.node.stats.LightSample;

public class StatisticsManagerServiceImpl
extends DefaultManager
implements StatisticsManagerService {
    private static final long serialVersionUID = 1L;
    private transient StatisticsManager statsManager = null;

    @Override
    public Collection<LightSample> getSamples() throws Exception {
        this.checkIsEnable();
        if (this.statsManager == null) {
            this.initManager();
        }
        try {
            Collection<LightSample> all = this.statsManager.getSamples();
            return all;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG042E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public LightSample getCurrentSample() throws Exception {
        this.checkIsEnable();
        if (this.statsManager == null) {
            this.initManager();
        }
        try {
            return this.statsManager.getCurrentSample();
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG042E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public String displayRequestors(String resorceKey) throws Exception {
        this.checkIsEnable();
        if (this.statsManager == null) {
            this.initManager();
        }
        try {
            return this.statsManager.displayRequestors(resorceKey);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG042E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public Collection<RedoStatement> getAllRedoStatements() throws Exception {
        this.checkIsEnable();
        if (this.statsManager == null) {
            this.initManager();
        }
        try {
            return this.statsManager.getAllRedoStatements();
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG042E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    private synchronized void initManager() throws Exception {
        if (this.statsManager == null) {
            try {
                this.statsManager = new StatisticsManager();
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG042E, (Throwable)ex);
                throw new Exception(ex.getMessage());
            }
        }
    }
}

