/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.util.Map;
import javax.servlet.http.HttpSession;
import org.pepstock.jem.gwt.client.security.LoggedUser;
import org.pepstock.jem.gwt.client.services.LoginManagerService;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.LoginManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.security.UserPreference;

public class LoginManagerServiceImpl
extends DefaultManager
implements LoginManagerService {
    private static final long serialVersionUID = 1L;
    private transient LoginManager loginManager = null;

    @Override
    public LoggedUser getUser() throws Exception {
        this.checkIsEnable();
        if (this.loginManager == null) {
            this.initManager();
        }
        try {
            return this.loginManager.getUser();
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG039E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public LoggedUser login(String userid, String password) throws Exception {
        this.checkIsEnable();
        if (this.loginManager == null) {
            this.initManager();
        }
        try {
            return this.loginManager.login(userid, password);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG039E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public Boolean logoff(Map<String, UserPreference> preferences) throws Exception {
        Boolean result = Boolean.FALSE;
        try {
            if (this.loginManager != null) {
                result = this.isEnable() ? this.loginManager.logoff(preferences) : this.loginManager.logoff();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        HttpSession session = super.getThreadLocalRequest().getSession();
        if (session != null) {
            session.invalidate();
        }
        return result;
    }

    @Override
    public Boolean storePreferences(Map<String, UserPreference> preferences) throws Exception {
        this.checkIsEnable();
        if (this.loginManager == null) {
            this.initManager();
        }
        try {
            return this.loginManager.storePreferences(preferences);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG039E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    private synchronized void initManager() throws Exception {
        if (this.loginManager == null) {
            try {
                this.loginManager = new LoginManager();
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG039E, (Throwable)ex);
                throw new Exception(ex.getMessage());
            }
        }
    }
}

