/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.util.ArrayList;
import java.util.Collection;
import org.pepstock.jem.gwt.client.services.CommonResourcesManagerService;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.CommonResourcesManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.resources.CryptedValueAndHash;
import org.pepstock.jem.node.resources.Resource;

public class CommonResourcesManagerServiceImpl
extends DefaultManager
implements CommonResourcesManagerService {
    private static final long serialVersionUID = 1L;
    private transient CommonResourcesManager resourcesManager = null;

    @Override
    public Collection<Resource> getCommonResources(String filter) throws Exception {
        this.checkIsEnable();
        if (this.resourcesManager == null) {
            this.initManager();
        }
        try {
            return new ArrayList<Resource>(this.resourcesManager.values(filter));
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG037E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public Boolean addCommonResource(Resource resource) throws Exception {
        this.checkIsEnable();
        if (this.resourcesManager == null) {
            this.initManager();
        }
        try {
            return this.resourcesManager.put(resource);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG037E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public Boolean updateCommonResource(Resource resource) throws Exception {
        this.checkIsEnable();
        if (this.resourcesManager == null) {
            this.initManager();
        }
        try {
            return this.resourcesManager.put(resource);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG037E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public Boolean removeCommonResource(Collection<Resource> resources) throws Exception {
        this.checkIsEnable();
        if (this.resourcesManager == null) {
            this.initManager();
        }
        try {
            boolean result = true;
            for (Resource resource : resources) {
                result = result && this.resourcesManager.remove(resource.getName());
            }
            return result;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG037E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public CryptedValueAndHash getEncryptedSecret(String secret) throws Exception {
        this.checkIsEnable();
        if (this.resourcesManager == null) {
            this.initManager();
        }
        try {
            return this.resourcesManager.getEncryptedSecret(secret);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG037E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    private synchronized void initManager() throws Exception {
        if (this.resourcesManager == null) {
            try {
                this.resourcesManager = new CommonResourcesManager();
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG037E, (Throwable)ex);
                throw new Exception(ex.getMessage());
            }
        }
    }
}

