/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.config;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.RegExValidatingTextBox;
import org.pepstock.jem.gwt.client.commons.Styles;

public class NetworkPanel
extends VerticalPanel {
    private static final String ADDRESS_LABEL = "IP Address:";
    private static final String ADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String ADDRESS_OK_TITLE = "Address (Ip Address).";
    private static final String ADDRESS_ERROR_TITLE = "Please insert a correct Address (Ip Address).";
    public static final int SPACING = 5;
    public static final int LABEL_HEIGHT = 24;
    public static final int WIDTH = 300;
    private final Button add = new Button("Add");
    private final RegExValidatingTextBox addressBox = new RegExValidatingTextBox("Please insert a correct Address (Ip Address).", "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private InspectListener<String> listener = null;

    public NetworkPanel(String header) {
        this.setWidth(Sizes.toString(300));
        this.setSpacing(5);
        this.add.setEnabled(false);
        Label label = new Label(header);
        label.addStyleName(Styles.INSTANCE.common().bold());
        label.setHeight(Sizes.toString(24));
        this.add((Widget)label);
        this.addressBox.setVisibleLength(40);
        this.addressBox.setTitle(ADDRESS_OK_TITLE);
        this.addressBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (NetworkPanel.this.addressBox.isValidText()) {
                    NetworkPanel.this.add.setEnabled(true);
                } else {
                    NetworkPanel.this.add.setEnabled(false);
                }
            }
        });
        this.add.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (NetworkPanel.this.listener != null) {
                    NetworkPanel.this.listener.inspect(NetworkPanel.this.addressBox.getText());
                }
            }
        });
        Label addressLabel = new Label();
        addressLabel.setText(ADDRESS_LABEL);
        this.add((Widget)addressLabel);
        this.add((Widget)this.addressBox);
        this.add((Widget)this.add);
    }

    public InspectListener<String> getListener() {
        return this.listener;
    }

    public void setListener(InspectListener<String> listener) {
        this.listener = listener;
    }

    public void clear() {
        this.addressBox.setText("");
        this.setEnabled(false);
    }

    public void setEnabled(boolean enabled) {
        this.add.setEnabled(enabled);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

