/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.config;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.List;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.CellTableStyle;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.components.RemovePanel;
import org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.config.NetworkCell;
import org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.config.NetworkPanel;
import org.pepstock.jem.node.configuration.SwarmConfiguration;

public class NetworkEditConfig
extends HorizontalPanel
implements InspectListener<String>,
ClickHandler,
ResizeCapable {
    private SwarmConfiguration swarmConfiguration = null;
    private RemovePanel remove = new RemovePanel();
    private NetworkPanel networkPanel = null;
    private CellList<String> cellList = null;
    private ScrollPanel scroller = new ScrollPanel();
    private final SingleSelectionModel<String> selectionModel = new SingleSelectionModel();

    public NetworkEditConfig(SwarmConfiguration swarmConfiguration) {
        this.setSwarmConfiguration(swarmConfiguration);
        this.cellList = new CellList((Cell)new NetworkCell(Images.INSTANCE.networkAddress()), (CellList.Resources)GWT.create(CellTableStyle.class));
        this.networkPanel = new NetworkPanel("Network Properties");
        this.networkPanel.setListener(this);
        this.add((Widget)this.networkPanel);
        this.cellList.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.cellList.setSelectionModel(this.selectionModel);
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                String selected = (String)NetworkEditConfig.this.selectionModel.getSelectedObject();
                if (selected != null) {
                    NetworkEditConfig.this.remove.setEnabled(true);
                }
            }
        });
        this.cellList.setRowCount(swarmConfiguration.getNetworks().size(), true);
        this.cellList.setRowData(0, (List)swarmConfiguration.getNetworks());
        this.scroller.setWidget(this.cellList);
        VerticalPanel scrollHolder = new VerticalPanel();
        scrollHolder.setSize("100%", "100%");
        scrollHolder.addStyleName(Styles.INSTANCE.administration().nodeList());
        scrollHolder.add((Widget)this.scroller);
        VerticalPanel listContainer = new VerticalPanel();
        listContainer.setSpacing(5);
        Label label = new Label("Network Addresses");
        label.addStyleName(Styles.INSTANCE.common().bold());
        label.setHeight(Sizes.toString(24));
        listContainer.add((Widget)label);
        listContainer.add((Widget)scrollHolder);
        this.add((Widget)listContainer);
        this.remove.setClickHandler(this);
        this.add((Widget)this.remove);
    }

    public SwarmConfiguration getSwarmConfiguration() {
        return this.swarmConfiguration;
    }

    public void setSwarmConfiguration(SwarmConfiguration swarmConfiguration) {
        this.swarmConfiguration = swarmConfiguration;
    }

    public void remove(String selected) {
        if (selected != null) {
            this.swarmConfiguration.getNetworks().remove(selected);
            this.cellList.setRowCount(this.swarmConfiguration.getNetworks().size());
            this.cellList.setRowData(0, (List)this.swarmConfiguration.getNetworks());
        }
        this.remove.setEnabled(false);
    }

    public void add(String selected) {
        if (!this.swarmConfiguration.getNetworks().contains(selected)) {
            this.swarmConfiguration.getNetworks().add(selected);
            this.cellList.setRowCount(this.swarmConfiguration.getNetworks().size());
            this.cellList.setRowData(0, (List)this.swarmConfiguration.getNetworks());
            this.networkPanel.clear();
            if (this.selectionModel.isSelected((Object)selected)) {
                this.remove.setEnabled(true);
            }
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        int widthInputPanel = 310;
        int widthRemovePanel = 110;
        int width = availableWidth - widthInputPanel - widthRemovePanel - 5 - 5 - 1 - 1;
        int height = availableHeight - 5 - 5 - 5 - 24 - 1 - 1;
        this.scroller.setHeight(Sizes.toString(height));
        this.scroller.setWidth(Sizes.toString(width));
    }

    public void onClick(ClickEvent event) {
        String selected = (String)this.selectionModel.getSelectedObject();
        this.remove(selected);
    }

    @Override
    public void inspect(String object) {
        this.add(object);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.administration().ensureInjected();
    }
}

