/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.config;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.DefaultInspectorItem;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.UITools;
import org.pepstock.jem.node.configuration.SwarmConfiguration;

public class GeneralViewConfig
extends DefaultInspectorItem {
    private final DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
    private SwarmConfiguration swarmConfiguration = null;
    private Label groupName = new Label();
    private Label netInterface = new Label();
    private Label port = new Label();
    private CheckBox isConfigurationEnabled = new CheckBox();
    private Label user = new Label();
    private Label lastModified = new Label();

    public GeneralViewConfig(SwarmConfiguration swarmConfiguration) {
        VerticalPanel nodeVp = new VerticalPanel();
        nodeVp.setWidth("100%");
        nodeVp.setHeight("100%");
        Label genLabel = new Label("General information");
        genLabel.setWidth("100%");
        genLabel.setStyleName(Styles.INSTANCE.inspector().title());
        genLabel.addStyleName(Styles.INSTANCE.common().bold());
        nodeVp.add((Widget)genLabel);
        FlexTable layout = new FlexTable();
        layout.setCellPadding(10);
        layout.setWidth("100%");
        layout.setHTML(0, 0, "Enabled");
        layout.setWidget(0, 1, (Widget)this.isConfigurationEnabled);
        layout.setHTML(1, 0, "Group name");
        layout.setWidget(1, 1, (Widget)this.groupName);
        layout.setHTML(2, 0, "Port");
        layout.setWidget(2, 1, (Widget)this.port);
        layout.setHTML(3, 0, "Network interface");
        layout.setWidget(3, 1, (Widget)this.netInterface);
        layout.setHTML(4, 0, "User");
        layout.setWidget(4, 1, (Widget)this.user);
        layout.setHTML(5, 0, "Last update");
        layout.setWidget(5, 1, (Widget)this.lastModified);
        UITools.setFlexTableStyles(layout, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight(), Styles.INSTANCE.common().bold());
        nodeVp.add((Widget)layout);
        this.add((Widget)nodeVp);
        this.setSwarmConfiguration(swarmConfiguration);
    }

    public SwarmConfiguration getSwarmConfiguration() {
        return this.swarmConfiguration;
    }

    public void setSwarmConfiguration(SwarmConfiguration swarmConfiguration) {
        this.swarmConfiguration = swarmConfiguration;
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        this.groupName.setText(this.swarmConfiguration.getGroupName());
        this.port.setText(String.valueOf(this.swarmConfiguration.getPort()));
        this.isConfigurationEnabled.setValue(Boolean.valueOf(this.swarmConfiguration.isEnabled()));
        this.isConfigurationEnabled.setEnabled(false);
        this.user.setText(this.swarmConfiguration.getUser());
        if (this.swarmConfiguration.getLastModified() != null) {
            this.lastModified.setText(this.dtf.format(this.swarmConfiguration.getLastModified()));
        }
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.inspector().ensureInjected();
    }
}

