/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.swarm;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.AnchorTextColumn;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.commons.TextFilterableHeader;
import org.pepstock.jem.gwt.client.panels.swarm.NodesComparator;
import org.pepstock.jem.util.filters.fields.NodeFilterFields;

public class NodesTable
extends AbstractTable<NodeInfoBean> {
    @Override
    public IndexedColumnComparator<NodeInfoBean> initCellTable(CellTable<NodeInfoBean> table) {
        AnchorTextColumn<NodeInfoBean> name = new AnchorTextColumn<NodeInfoBean>(){

            @Override
            public String getValue(NodeInfoBean object) {
                return object.getLabel();
            }

            @Override
            public void onClick(int index, NodeInfoBean object, String value) {
                NodesTable.this.getInspectListener().inspect(object);
            }
        };
        name.setSortable(true);
        table.addColumn((Column)name, (Header)new TextFilterableHeader("Name", NodeFilterFields.NAME.getName()));
        TextColumn<NodeInfoBean> hostname = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.getHostname();
            }
        };
        hostname.setSortable(true);
        table.addColumn((Column)hostname, (Header)new TextFilterableHeader("Hostname", NodeFilterFields.HOSTNAME.getName()));
        TextColumn<NodeInfoBean> executionEnvironment = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.getExecutionEnvironment().getEnvironment();
            }
        };
        executionEnvironment.setSortable(true);
        table.addColumn((Column)executionEnvironment, (Header)new TextFilterableHeader("Environment", NodeFilterFields.ENVIRONMENT.getName()));
        TextColumn<NodeInfoBean> status = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean object) {
                if (object == null || object.getStatus() == null) {
                    return "";
                }
                return object.getStatus();
            }

            public void render(Cell.Context context, NodeInfoBean object, SafeHtmlBuilder sb) {
                if (object == null || object.getStatus() == null || object.getStatus().trim().isEmpty()) {
                    return;
                }
                String statusString = object.getStatus();
                NodeStatusImages statusObject = statusString.equals(NodeStatusImages.UNKNOWN.toString()) ? NodeStatusImages.UNKNOWN : (statusString.equals(NodeStatusImages.STARTING.toString()) ? NodeStatusImages.STARTING : (statusString.equals(NodeStatusImages.INACTIVE.toString()) ? NodeStatusImages.INACTIVE : (statusString.equals(NodeStatusImages.ACTIVE.toString()) ? NodeStatusImages.ACTIVE : (statusString.equals(NodeStatusImages.DRAINED.toString()) ? NodeStatusImages.DRAINED : (statusString.equals(NodeStatusImages.DRAINING.toString()) ? NodeStatusImages.DRAINING : (statusString.equals(NodeStatusImages.SHUTTING_DOWN.toString()) ? NodeStatusImages.SHUTTING_DOWN : NodeStatusImages.INACTIVE))))));
                sb.appendHtmlConstant("<table>");
                sb.appendHtmlConstant("<tr><td>");
                String imageHtml = AbstractImagePrototype.create((ImageResource)statusObject.getImage()).getHTML();
                sb.appendHtmlConstant(imageHtml);
                sb.appendHtmlConstant("</td>");
                sb.appendHtmlConstant("<td align='left' valign='middle'>");
                sb.appendEscaped(statusString);
                if (!object.isOperational()) {
                    sb.appendEscaped(" (not operational)");
                }
                sb.appendHtmlConstant("</td></tr></table>");
            }
        };
        status.setSortable(true);
        table.addColumn((Column)status, (Header)new TextFilterableHeader("Status", NodeFilterFields.STATUS.getName()));
        TextColumn<NodeInfoBean> systemName = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.getSystemName();
            }
        };
        systemName.setSortable(true);
        table.addColumn((Column)systemName, (Header)new TextFilterableHeader("OS", NodeFilterFields.OS.getName()));
        return new NodesComparator(0, "swarm.sort");
    }

    static enum NodeStatusImages {
        UNKNOWN("UNKNOWN", Images.INSTANCE.ledGray18()),
        STARTING("STARTING", Images.INSTANCE.ledLightGreen18()),
        INACTIVE("INACTIVE", Images.INSTANCE.ledBlue18()),
        ACTIVE("ACTIVE", Images.INSTANCE.ledGreen18()),
        DRAINED("DRAINED", Images.INSTANCE.ledRed18()),
        DRAINING("DRAINING", Images.INSTANCE.ledYellow18()),
        SHUTTING_DOWN("SHUTTING_DOWN", Images.INSTANCE.ledGray18());

        private String value;
        private ImageResource image;

        private NodeStatusImages(String value, ImageResource image) {
            this.value = value;
            this.image = image;
        }

        public ImageResource getImage() {
            return this.image;
        }

        public String toString() {
            return this.value;
        }
    }
}

