/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.permissions;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.util.Iterator;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.CheckBoxPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.PermissionItem;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

public class RolesPermissionsPanel
extends CheckBoxPermissionsPanel {
    private PermissionItem rolesAll = new PermissionItem("All", "allows to have all actions on roles management", "roles:*");
    private PermissionItem rolesCreate = new PermissionItem("Read", "allows to have READ permission, to see roles attributes", "roles:read");
    private PermissionItem rolesDelete = new PermissionItem("Delete", "allows to have DELETE permission, to remove roles", "roles:delete");
    private PermissionItem rolesRead = new PermissionItem("Create", "allows to have CREATE permission, to create new roles", "roles:create");
    private PermissionItem rolesUpdate = new PermissionItem("Update", "allows to have UPDATE permission, to change roles", "roles:update");

    public RolesPermissionsPanel(Role role) {
        super(role);
        for (String permission : role.getPermissions()) {
            if (!permission.startsWith("roles") && !permission.startsWith("*")) continue;
            if (permission.equalsIgnoreCase("roles:*") || permission.startsWith("*")) {
                this.rolesAll.setValue(true);
                for (int i = 0; i < Permissions.ROLES_ALL.length; ++i) {
                    PermissionItem checkBox = this.getPermissionItemByPermission(Permissions.ROLES_ALL[i]);
                    if (checkBox == null) continue;
                    checkBox.setValue(false);
                    checkBox.setEnabled(false);
                }
                continue;
            }
            PermissionItem checkBox = this.getPermissionItemByPermission(permission);
            if (checkBox == null) continue;
            checkBox.setValue(true);
        }
        this.rolesAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (RolesPermissionsPanel.this.rolesAll.getValue()) {
                    if (!RolesPermissionsPanel.this.getRole().getPermissions().contains("roles:*")) {
                        Iterator iter = RolesPermissionsPanel.this.getRole().getPermissions().iterator();
                        while (iter.hasNext()) {
                            String permission = (String)iter.next();
                            if (!permission.startsWith("roles")) continue;
                            iter.remove();
                        }
                        for (int i = 0; i < Permissions.ROLES_ALL.length; ++i) {
                            PermissionItem checkBox = RolesPermissionsPanel.this.getPermissionItemByPermission(Permissions.ROLES_ALL[i]);
                            if (checkBox == null) continue;
                            checkBox.setValue(false);
                            checkBox.setEnabled(false);
                        }
                        RolesPermissionsPanel.this.getRole().getPermissions().add("roles:*");
                    }
                } else {
                    RolesPermissionsPanel.this.getRole().getPermissions().remove("roles:*");
                    for (int i = 0; i < Permissions.ROLES_ALL.length; ++i) {
                        PermissionItem checkBox = RolesPermissionsPanel.this.getPermissionItemByPermission(Permissions.ROLES_ALL[i]);
                        if (checkBox == null) continue;
                        checkBox.setEnabled(true);
                    }
                }
            }
        });
        this.loadCheckBoxAction(this.rolesRead);
        this.loadCheckBoxAction(this.rolesDelete);
        this.loadCheckBoxAction(this.rolesCreate);
        this.loadCheckBoxAction(this.rolesUpdate);
        this.setItems(this.rolesAll, this.rolesRead, this.rolesDelete, this.rolesCreate, this.rolesUpdate);
    }

    private PermissionItem getPermissionItemByPermission(String permission) {
        if (permission.equalsIgnoreCase("roles:create")) {
            return this.rolesCreate;
        }
        if (permission.equalsIgnoreCase("roles:delete")) {
            return this.rolesDelete;
        }
        if (permission.equalsIgnoreCase("roles:update")) {
            return this.rolesUpdate;
        }
        if (permission.equalsIgnoreCase("roles:read")) {
            return this.rolesRead;
        }
        if (permission.equalsIgnoreCase("roles:*")) {
            return this.rolesAll;
        }
        return null;
    }
}

