/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.permissions;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.util.Iterator;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.CheckBoxPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.PermissionItem;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

public class ResourcesPermissionsPanel
extends CheckBoxPermissionsPanel {
    private PermissionItem resourcesAll = new PermissionItem("All", "allows to have all actions on resources management", "resources:*");
    private PermissionItem resourcesRead = new PermissionItem("Read", "allows to have READ permission, to see resources attributes", "resources:read");
    private PermissionItem resourcesDelete = new PermissionItem("Delete", "allows to have DELETE permission, to remove resources", "resources:delete");
    private PermissionItem resourcesCreate = new PermissionItem("Create", "allows to have CREATE permission, to create new resources", "resources:create");
    private PermissionItem resourcesUpdate = new PermissionItem("Update", "allows to have UPDATE permission, to change resources", "resources:update");

    public ResourcesPermissionsPanel(Role role) {
        super(role);
        for (String permission : role.getPermissions()) {
            if (!permission.startsWith("resources") && !permission.startsWith("*")) continue;
            if (permission.equalsIgnoreCase("resources:*") || permission.startsWith("*")) {
                this.resourcesAll.setValue(true);
                for (int i = 0; i < Permissions.RESOURCES_ALL.length; ++i) {
                    PermissionItem checkBox = this.getPermissionItemByPermission(Permissions.RESOURCES_ALL[i]);
                    if (checkBox == null) continue;
                    checkBox.setValue(false);
                    checkBox.setEnabled(false);
                }
                continue;
            }
            PermissionItem checkBox = this.getPermissionItemByPermission(permission);
            if (checkBox == null) continue;
            checkBox.setValue(true);
        }
        this.resourcesAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ResourcesPermissionsPanel.this.resourcesAll.getValue()) {
                    if (!ResourcesPermissionsPanel.this.getRole().getPermissions().contains("resources:*")) {
                        Iterator iter = ResourcesPermissionsPanel.this.getRole().getPermissions().iterator();
                        while (iter.hasNext()) {
                            String permission = (String)iter.next();
                            if (!permission.startsWith("resources")) continue;
                            iter.remove();
                        }
                        for (int i = 0; i < Permissions.RESOURCES_ALL.length; ++i) {
                            PermissionItem checkBox = ResourcesPermissionsPanel.this.getPermissionItemByPermission(Permissions.RESOURCES_ALL[i]);
                            if (checkBox == null) continue;
                            checkBox.setValue(false);
                            checkBox.setEnabled(false);
                        }
                        ResourcesPermissionsPanel.this.getRole().getPermissions().add("resources:*");
                    }
                } else {
                    ResourcesPermissionsPanel.this.getRole().getPermissions().remove("resources:*");
                    for (int i = 0; i < Permissions.RESOURCES_ALL.length; ++i) {
                        PermissionItem checkBox = ResourcesPermissionsPanel.this.getPermissionItemByPermission(Permissions.RESOURCES_ALL[i]);
                        if (checkBox == null) continue;
                        checkBox.setEnabled(true);
                    }
                }
            }
        });
        this.loadCheckBoxAction(this.resourcesRead);
        this.loadCheckBoxAction(this.resourcesDelete);
        this.loadCheckBoxAction(this.resourcesCreate);
        this.loadCheckBoxAction(this.resourcesUpdate);
        this.setItems(this.resourcesAll, this.resourcesRead, this.resourcesDelete, this.resourcesCreate, this.resourcesUpdate);
    }

    private PermissionItem getPermissionItemByPermission(String permission) {
        if (permission.equalsIgnoreCase("resources:read")) {
            return this.resourcesRead;
        }
        if (permission.equalsIgnoreCase("resources:delete")) {
            return this.resourcesDelete;
        }
        if (permission.equalsIgnoreCase("resources:create")) {
            return this.resourcesCreate;
        }
        if (permission.equalsIgnoreCase("resources:update")) {
            return this.resourcesUpdate;
        }
        if (permission.equalsIgnoreCase("resources:*")) {
            return this.resourcesAll;
        }
        return null;
    }
}

